/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.reward.block;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.data.type.ActionDataType;
import com.daqem.arc.api.action.result.ActionResult;
import com.daqem.arc.api.reward.AbstractReward;
import com.daqem.arc.api.reward.serializer.IRewardSerializer;
import com.daqem.arc.api.reward.type.IRewardType;
import com.daqem.arc.api.reward.type.RewardType;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class BlockDropMultiplierReward
extends AbstractReward {
    private final int multiplier;

    public BlockDropMultiplierReward(double chance, int priority, int multiplier) {
        super(chance, priority);
        this.multiplier = multiplier;
    }

    @Override
    public Component getDescription() {
        return this.getDescription(this.multiplier);
    }

    @Override
    public ActionResult apply(ActionData actionData) {
        BlockPos blockPos;
        BlockState blockState = actionData.getData(ActionDataType.BLOCK_STATE);
        if (blockState != null && (blockPos = actionData.getData(ActionDataType.BLOCK_POSITION)) != null) {
            Level level = actionData.getData(ActionDataType.WORLD);
            if (level == null) {
                level = actionData.getPlayer().arc$getLevel();
            }
            if (level != null && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Vec3 vec3 = Vec3.atCenterOf((Vec3i)blockPos);
                List drops = blockState.getDrops(new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)vec3).withParameter(LootContextParams.TOOL, (Object)actionData.getPlayer().arc$getPlayer().getMainHandItem()).withParameter(LootContextParams.BLOCK_STATE, (Object)blockState).withParameter(LootContextParams.THIS_ENTITY, (Object)actionData.getPlayer().arc$getPlayer()));
                for (ItemStack drop : drops) {
                    for (int i = 1; i < this.multiplier; ++i) {
                        level.addFreshEntity((Entity)new ItemEntity(level, vec3.x(), vec3.y(), vec3.z(), drop));
                    }
                }
            }
        }
        return new ActionResult();
    }

    @Override
    public IRewardType<?> getType() {
        return RewardType.BLOCK_DROP_MULTIPLIER;
    }

    public static class Serializer
    implements IRewardSerializer<BlockDropMultiplierReward> {
        @Override
        public BlockDropMultiplierReward fromJson(JsonObject jsonObject, double chance, int priority) {
            return new BlockDropMultiplierReward(chance, priority, GsonHelper.getAsInt((JsonObject)jsonObject, (String)"multiplier"));
        }

        @Override
        public BlockDropMultiplierReward fromNetwork(RegistryFriendlyByteBuf friendlyByteBuf, double chance, int priority) {
            return new BlockDropMultiplierReward(chance, priority, friendlyByteBuf.readInt());
        }

        @Override
        public void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, BlockDropMultiplierReward type) {
            IRewardSerializer.super.toNetwork(friendlyByteBuf, type);
            friendlyByteBuf.writeInt(type.multiplier);
        }
    }
}

