/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.reward.effect;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.result.ActionResult;
import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.arc.api.reward.AbstractReward;
import com.daqem.arc.api.reward.serializer.IRewardSerializer;
import com.daqem.arc.api.reward.type.IRewardType;
import com.daqem.arc.api.reward.type.RewardType;
import com.google.gson.JsonObject;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;

public class EffectReward
extends AbstractReward {
    private final MobEffect effect;
    private final int duration;
    private final int amplifier;

    public EffectReward(double chance, int priority, MobEffect effect, int duration, int amplifier) {
        super(chance, priority);
        this.effect = effect;
        this.duration = duration;
        this.amplifier = amplifier;
    }

    @Override
    public Component getDescription() {
        return this.getDescription(this.effect.getDisplayName(), MobEffectUtil.formatDuration((MobEffectInstance)this.getMobEffectInstance(), (float)1.0f, (float)20.0f), this.amplifier + 1);
    }

    @Override
    public ActionResult apply(ActionData actionData) {
        ArcPlayer player = actionData.getPlayer();
        player.arc$getPlayer().addEffect(this.getMobEffectInstance());
        return new ActionResult();
    }

    private MobEffectInstance getMobEffectInstance() {
        return new MobEffectInstance(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)this.effect), this.duration, this.amplifier);
    }

    @Override
    public IRewardType<?> getType() {
        return RewardType.EFFECT;
    }

    public static class Serializer
    implements IRewardSerializer<EffectReward> {
        @Override
        public EffectReward fromJson(JsonObject jsonObject, double chance, int priority) {
            return new EffectReward(chance, priority, this.getMobEffect(jsonObject, "effect"), GsonHelper.getAsInt((JsonObject)jsonObject, (String)"duration"), GsonHelper.getAsInt((JsonObject)jsonObject, (String)"amplifier", (int)0));
        }

        @Override
        public EffectReward fromNetwork(RegistryFriendlyByteBuf friendlyByteBuf, double chance, int priority) {
            return new EffectReward(chance, priority, (MobEffect)ByteBufCodecs.registry((ResourceKey)Registries.MOB_EFFECT).decode((Object)friendlyByteBuf), friendlyByteBuf.readVarInt(), friendlyByteBuf.readVarInt());
        }

        @Override
        public void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, EffectReward type) {
            IRewardSerializer.super.toNetwork(friendlyByteBuf, type);
            ByteBufCodecs.registry((ResourceKey)Registries.MOB_EFFECT).encode((Object)friendlyByteBuf, (Object)type.effect);
            friendlyByteBuf.writeVarInt(type.duration);
            friendlyByteBuf.writeVarInt(type.amplifier);
        }
    }
}

