/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.reward.entity;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.data.type.ActionDataType;
import com.daqem.arc.api.action.result.ActionResult;
import com.daqem.arc.api.reward.AbstractReward;
import com.daqem.arc.api.reward.serializer.IRewardSerializer;
import com.daqem.arc.api.reward.type.IRewardType;
import com.daqem.arc.api.reward.type.RewardType;
import com.google.gson.JsonObject;
import java.util.Random;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class MultipleArrowsReward
extends AbstractReward {
    private final int amount;

    public MultipleArrowsReward(double chance, int priority, int amount) {
        super(chance, priority);
        this.amount = amount;
    }

    @Override
    public Component getDescription() {
        return this.getDescription(this.amount);
    }

    @Override
    public IRewardType<?> getType() {
        return RewardType.MULTIPLE_ARROWS;
    }

    @Override
    public ActionResult apply(ActionData actionData) {
        Entity entity = actionData.getData(ActionDataType.ENTITY);
        if (entity instanceof AbstractArrow) {
            ItemStack bow;
            AbstractArrow shotArrow = (AbstractArrow)entity;
            Player player = actionData.getPlayer().arc$getPlayer();
            if (player.getMainHandItem().getItem() instanceof BowItem) {
                bow = player.getMainHandItem();
            } else if (player.getOffhandItem().getItem() instanceof BowItem) {
                bow = player.getOffhandItem();
            } else {
                return new ActionResult();
            }
            Item item = bow.getItem();
            if (item instanceof BowItem) {
                BowItem bowItem = (BowItem)item;
                float power = BowItem.getPowerForTime((int)(bowItem.getUseDuration(bow, (LivingEntity)player) - player.getUseItemRemainingTicks()));
                float[] afloat = this.getShotPitches(new Random());
                int[] arrowPositions = MultipleArrowsReward.scatterArrows(this.amount);
                for (int i = 0; i < this.amount; ++i) {
                    this.shootProjectile(shotArrow, player.level(), (LivingEntity)player, bow, Items.ARROW.getDefaultInstance(), afloat[1], power * 3.0f, arrowPositions[i]);
                }
            }
        }
        return new ActionResult();
    }

    public static int[] scatterArrows(int numArrows) {
        if (numArrows < 1 || numArrows > 20) {
            throw new IllegalArgumentException("Number of arrows should be between 1 and 20.");
        }
        int[] arrowPositions = new int[numArrows];
        double interval = 20.0 / (double)(numArrows - 1);
        for (int i = 0; i < numArrows; ++i) {
            arrowPositions[i] = (int)(-10.0 + (double)i * interval);
        }
        return arrowPositions;
    }

    private void shootProjectile(AbstractArrow shotArrow, Level level, LivingEntity livingEntity, ItemStack bow, final ItemStack arrow, float shotPitch, float power, float pitch) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            AbstractArrow projectile = new AbstractArrow(this, EntityType.ARROW, livingEntity, level, arrow, bow){

                @NotNull
                protected ItemStack getDefaultPickupItem() {
                    return arrow;
                }

                protected void onHitBlock(@NotNull BlockHitResult blockHitResult) {
                    super.onHitBlock(blockHitResult);
                    this.discard();
                }
            };
            projectile.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
            Vec3 vec3 = player.getUpVector(1.0f);
            Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(pitch * ((float)Math.PI / 180)), vec3.x, vec3.y, vec3.z);
            Vec3 vec32 = player.getViewVector(1.0f);
            Vector3f vector3f = vec32.toVector3f().rotate((Quaternionfc)quaternionf);
            projectile.shoot((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), power, 1.0f);
            bow.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
            level.addFreshEntity((Entity)projectile);
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, shotPitch);
        }
    }

    private float[] getShotPitches(Random random) {
        boolean flag = random.nextBoolean();
        return new float[]{1.0f, this.getRandomShotPitch(flag, random), this.getRandomShotPitch(!flag, random)};
    }

    private float getRandomShotPitch(boolean p_150798_, Random random) {
        float f = p_150798_ ? 0.63f : 0.43f;
        return 1.0f / (random.nextFloat() * 0.5f + 1.8f) + f;
    }

    public static class Serializer
    implements IRewardSerializer<MultipleArrowsReward> {
        @Override
        public MultipleArrowsReward fromJson(JsonObject jsonObject, double chance, int priority) {
            return new MultipleArrowsReward(chance, priority, Math.min(20, Math.max(1, GsonHelper.getAsInt((JsonObject)jsonObject, (String)"amount"))));
        }

        @Override
        public MultipleArrowsReward fromNetwork(RegistryFriendlyByteBuf friendlyByteBuf, double chance, int priority) {
            return new MultipleArrowsReward(chance, priority, friendlyByteBuf.readInt());
        }

        @Override
        public void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, MultipleArrowsReward type) {
            IRewardSerializer.super.toNetwork(friendlyByteBuf, type);
            friendlyByteBuf.writeInt(type.amount);
        }
    }
}

