/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.reward.item;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.result.ActionResult;
import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.arc.api.reward.AbstractReward;
import com.daqem.arc.api.reward.serializer.IRewardSerializer;
import com.daqem.arc.api.reward.type.IRewardType;
import com.daqem.arc.api.reward.type.RewardType;
import com.google.gson.JsonObject;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;

public class ItemReward
extends AbstractReward {
    private final ItemStack itemStack;
    private final int amount;

    public ItemReward(double chance, int priority, ItemStack itemStack, int amount) {
        super(chance, priority);
        this.itemStack = itemStack;
        this.amount = amount;
    }

    @Override
    public Component getDescription() {
        return this.getDescription(this.amount, this.itemStack.getHoverName());
    }

    @Override
    public ActionResult apply(ActionData actionData) {
        ArcPlayer player = actionData.getPlayer();
        player.arc$getPlayer().addItem(this.itemStack.copy());
        return new ActionResult();
    }

    @Override
    public IRewardType<?> getType() {
        return RewardType.ITEM;
    }

    public static class Serializer
    implements IRewardSerializer<ItemReward> {
        @Override
        public ItemReward fromJson(JsonObject jsonObject, double chance, int priority) {
            ItemStack itemStack = this.getItemStack(jsonObject.get("item"));
            int amount = GsonHelper.getAsInt((JsonObject)jsonObject, (String)"amount", (int)1);
            itemStack.setCount(amount);
            return new ItemReward(chance, priority, itemStack, amount);
        }

        @Override
        public ItemReward fromNetwork(RegistryFriendlyByteBuf friendlyByteBuf, double chance, int priority) {
            return new ItemReward(chance, priority, (ItemStack)ItemStack.STREAM_CODEC.decode((Object)friendlyByteBuf), friendlyByteBuf.readInt());
        }

        @Override
        public void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, ItemReward type) {
            IRewardSerializer.super.toNetwork(friendlyByteBuf, type);
            ItemStack.STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)type.itemStack);
            friendlyByteBuf.writeInt(type.amount);
        }
    }
}

