/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.mixin;

import com.daqem.arc.api.player.ArcServerPlayer;
import com.daqem.arc.event.triggers.PlayerEvents;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractFurnaceBlockEntity.class})
public abstract class MixinAbstractFurnaceBlockEntity {
    @Shadow
    @Final
    private Object2IntOpenHashMap<ResourceLocation> recipesUsed;

    @Inject(at={@At(value="HEAD")}, method={"awardUsedRecipesAndPopExperience(Lnet/minecraft/server/level/ServerPlayer;)V"})
    private void awardUsedRecipesAndPopExperience(ServerPlayer serverPlayer, CallbackInfo ci) {
        if (serverPlayer instanceof ArcServerPlayer) {
            ArcServerPlayer arcServerPlayer = (ArcServerPlayer)serverPlayer;
            ServerLevel serverLevel = serverPlayer.serverLevel();
            this.recipesUsed.forEach((recipeId, recipeCount) -> serverLevel.getRecipeManager().byKey(recipeId).ifPresent(recipe -> {
                for (int i = 0; i < recipeCount; ++i) {
                    PlayerEvents.onSmeltItem(arcServerPlayer, recipe.value(), recipe.value().getResultItem((HolderLookup.Provider)arcServerPlayer.arc$getServerPlayer().getServer().registryAccess()), ((AbstractFurnaceBlockEntity)this).getBlockPos(), (Level)serverLevel);
                }
            }));
        }
    }
}

