/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.mixin;

import com.daqem.arc.api.player.ArcServerPlayer;
import com.daqem.arc.event.triggers.PlayerEvents;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AxeItem.class})
public abstract class MixinAxeItem
extends DiggerItem {
    @Shadow
    protected abstract Optional<BlockState> getStripped(BlockState var1);

    public MixinAxeItem(Tier tier, TagKey<Block> tagKey, Item.Properties properties) {
        super(tier, tagKey, properties);
    }

    @Inject(at={@At(value="HEAD")}, method={"useOn(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;"})
    public void useOn(UseOnContext useOnContext, CallbackInfoReturnable<InteractionResult> cir) {
        Player player = useOnContext.getPlayer();
        if (player instanceof ArcServerPlayer) {
            ArcServerPlayer serverPlayer = (ArcServerPlayer)player;
            BlockPos clickedPos = useOnContext.getClickedPos();
            BlockState blockState = serverPlayer.arc$getLevel().getBlockState(clickedPos);
            if (this.getStripped(blockState).isPresent()) {
                PlayerEvents.onStripLog(serverPlayer, clickedPos, useOnContext.getLevel());
            }
        }
    }
}

