/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.mixin;

import com.daqem.arc.api.action.result.ActionResult;
import com.daqem.arc.api.player.ArcServerPlayer;
import com.daqem.arc.event.triggers.PlayerEvents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity
extends Entity {
    public MixinLivingEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="RETURN")}, method={"addEffect(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/Entity;)Z"})
    private void addEffect(MobEffectInstance effect, Entity entity, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity self = (LivingEntity)this;
        if (self instanceof ArcServerPlayer) {
            ServerPlayer source;
            ArcServerPlayer serverPlayer = (ArcServerPlayer)self;
            if (self.getActiveEffectsMap().containsKey(effect.getEffect()) && entity instanceof ServerPlayer && (source = (ServerPlayer)entity).getName().getString().equals("a")) {
                return;
            }
            ActionResult actionResult = PlayerEvents.onEffectAdded(serverPlayer, effect, entity);
            if (actionResult.shouldCancelAction()) {
                self.removeEffect(effect.getEffect());
            }
        }
    }
}

