/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.mixin;

import com.daqem.arc.api.action.data.ActionDataBuilder;
import com.daqem.arc.api.action.data.type.ActionDataType;
import com.daqem.arc.api.action.holder.IActionHolder;
import com.daqem.arc.api.action.result.ActionResult;
import com.daqem.arc.api.action.type.ActionType;
import com.daqem.arc.api.condition.ICondition;
import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.arc.api.player.ArcServerPlayer;
import com.daqem.arc.data.PlayerActionHolderManager;
import com.daqem.arc.event.triggers.MovementEvents;
import com.daqem.arc.event.triggers.PlayerEvents;
import com.daqem.arc.event.triggers.StatEvents;
import com.daqem.arc.networking.ClientboundSyncPlayerActionHoldersPacket;
import com.daqem.arc.player.BlockPosCache;
import com.daqem.arc.player.stat.StatData;
import com.mojang.authlib.GameProfile;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.stats.Stat;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.GrindstoneMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayer.class})
public abstract class MixinServerPlayer
extends Player
implements ArcServerPlayer {
    @Shadow
    public ServerGamePacketListenerImpl connection;
    @Unique
    private Map<ResourceLocation, IActionHolder> arc$actionHolders = new HashMap<ResourceLocation, IActionHolder>();
    @Unique
    private NonNullList<StatData> arc$statData = NonNullList.create();
    @Unique
    private Map<ICondition, Integer> arc$lastDistanceInCm = new HashMap<ICondition, Integer>();
    @Unique
    private Map<ICondition, Integer> arc$lastRemainderInCm = new HashMap<ICondition, Integer>();
    @Unique
    private boolean arc$isSwimming = false;
    @Unique
    private int arc$swimmingDistanceInCm = 0;
    @Unique
    private boolean arc$isWalking = false;
    @Unique
    private float arc$walkingDistance = 0.0f;
    @Unique
    private boolean arc$isSprinting = false;
    @Unique
    private float arc$sprintingDistance = 0.0f;
    @Unique
    private boolean arc$isCrouching = false;
    @Unique
    private float arc$crouchingDistance = 0.0f;
    @Unique
    private boolean arc$isElytraFlying = false;
    @Unique
    private float arc$elytraFlyingDistance = 0.0f;
    @Unique
    private boolean arc$isGrinding = false;
    @Unique
    public boolean arc$isHorseRiding = false;
    @Unique
    public float arc$horseRidingDistance = 0.0f;
    @Unique
    public BlockPosCache arc$blockPosCache = new BlockPosCache();

    public MixinServerPlayer(Level level, BlockPos blockPos, float yaw, GameProfile gameProfile) {
        super(level, blockPos, yaw, gameProfile);
    }

    @Override
    public List<IActionHolder> arc$getActionHolders() {
        return new ArrayList<IActionHolder>(this.arc$actionHolders.values());
    }

    @Override
    public void arc$addActionHolder(IActionHolder actionHolder) {
        if (actionHolder == null) {
            return;
        }
        this.arc$actionHolders.put(actionHolder.getLocation(), actionHolder);
        this.arc$syncActionHoldersWithClient();
    }

    @Override
    public void arc$addActionHolders(List<IActionHolder> actionHolders) {
        if (actionHolders == null) {
            return;
        }
        for (IActionHolder actionHolder : actionHolders) {
            this.arc$addActionHolder(actionHolder);
        }
    }

    @Override
    public void arc$removeActionHolder(IActionHolder actionHolder) {
        this.arc$actionHolders.remove(actionHolder.getLocation());
    }

    @Override
    public void arc$clearActionHolders() {
        this.arc$actionHolders.clear();
    }

    @Override
    public ServerPlayer arc$getServerPlayer() {
        return (ServerPlayer)this;
    }

    @Override
    public NonNullList<StatData> arc$getStatData() {
        return this.arc$statData;
    }

    @Override
    public void arc$addStatData(StatData statData) {
        this.arc$statData.add((Object)statData);
    }

    @Override
    public void arc$setSwimmingDistanceInCm(int swimmingDistanceInCm) {
        this.arc$swimmingDistanceInCm = swimmingDistanceInCm;
    }

    @Override
    public void arc$setElytraFlyingDistanceInCm(float flyingDistanceInCm) {
        this.arc$elytraFlyingDistance = flyingDistanceInCm;
    }

    @Override
    public int arc$getLastDistanceInCm(ICondition distanceCondition) {
        Integer lastDistanceInCm = this.arc$lastDistanceInCm.get(distanceCondition);
        return lastDistanceInCm == null ? 0 : lastDistanceInCm;
    }

    @Override
    public void arc$setLastDistanceInCm(ICondition distanceCondition, int lastDistanceInCm) {
        this.arc$lastDistanceInCm.put(distanceCondition, lastDistanceInCm);
    }

    @Override
    public int arc$getLastRemainderInCm(ICondition distanceCondition) {
        Integer lastRemainderInCm = this.arc$lastRemainderInCm.get(distanceCondition);
        return lastRemainderInCm == null ? 0 : lastRemainderInCm;
    }

    @Override
    public void arc$setLastRemainderInCm(ICondition distanceCondition, int lastRemainderInCm) {
        this.arc$lastRemainderInCm.put(distanceCondition, lastRemainderInCm);
    }

    @Override
    public Map<ResourceLocation, IActionHolder> arc$getActionHoldersMap() {
        return this.arc$actionHolders;
    }

    @Override
    public Map<ICondition, Integer> arc$getLastDistancesInCm() {
        return this.arc$lastDistanceInCm;
    }

    @Override
    public Map<ICondition, Integer> arc$getLastRemaindersInCm() {
        return this.arc$lastRemainderInCm;
    }

    @Override
    public boolean arc$isSwimming() {
        return this.arc$isSwimming;
    }

    @Override
    public int arc$getSwimmingDistanceInCm() {
        return this.arc$swimmingDistanceInCm;
    }

    @Override
    public boolean arc$isWalking() {
        return this.arc$isWalking;
    }

    @Override
    public float arc$getWalkingDistance() {
        return this.arc$walkingDistance;
    }

    @Override
    public boolean arc$isSprinting() {
        return this.arc$isSprinting;
    }

    @Override
    public float arc$getSprintingDistance() {
        return this.arc$sprintingDistance;
    }

    @Override
    public boolean arc$isCrouching() {
        return this.arc$isCrouching;
    }

    @Override
    public float arc$getCrouchingDistance() {
        return this.arc$crouchingDistance;
    }

    @Override
    public boolean arc$isElytraFlying() {
        return this.arc$isElytraFlying;
    }

    @Override
    public float arc$getElytraFlyingDistance() {
        return this.arc$elytraFlyingDistance;
    }

    @Override
    public boolean arc$isGrinding() {
        return this.arc$isGrinding;
    }

    @Override
    public boolean arc$isHorseRiding() {
        return this.arc$isHorseRiding;
    }

    @Override
    public void arc$syncActionHoldersWithClient() {
        if (this.connection == null) {
            return;
        }
        NetworkManager.sendToPlayer((ServerPlayer)this.arc$getServerPlayer(), (CustomPacketPayload)new ClientboundSyncPlayerActionHoldersPacket(this.arc$getActionHolders()));
    }

    @Override
    public BlockPosCache arc$getBlockPosCache() {
        return this.arc$blockPosCache;
    }

    @NotNull
    public ItemStack eat(Level level, ItemStack itemStack, FoodProperties foodProperties) {
        PlayerEvents.onPlayerEat(this, itemStack);
        return super.eat(level, itemStack, foodProperties);
    }

    @Override
    public double arc$nextRandomDouble() {
        return this.arc$getServerPlayer().getRandom().nextDouble();
    }

    @Override
    @NotNull
    public Level arc$getLevel() {
        return super.level();
    }

    @Override
    public String arc$getName() {
        return super.getName().getString();
    }

    @Override
    public Player arc$getPlayer() {
        return this.arc$getServerPlayer();
    }

    @Inject(at={@At(value="TAIL")}, method={"tick()V"})
    public void tick(CallbackInfo ci) {
        Horse horse;
        Entity entity;
        if (this.arc$isSwimming && this.isSwimming()) {
            MovementEvents.onSwim(this, this.arc$swimmingDistanceInCm);
        } else if (this.arc$isSwimming) {
            this.arc$isSwimming = false;
            MovementEvents.onStopSwimming(this);
        } else if (this.isSwimming()) {
            this.arc$isSwimming = true;
            MovementEvents.onStartSwimming(this);
        }
        boolean isCurrentlyWalking = this.walkDist > this.arc$walkingDistance;
        float distance = this.walkDist - this.arc$walkingDistance;
        if (this.arc$isWalking && isCurrentlyWalking) {
            this.arc$walkingDistance = this.walkDist;
            MovementEvents.onWalk(this, (int)(this.arc$walkingDistance * 100.0f));
        } else if (this.arc$isWalking) {
            this.arc$isWalking = false;
            MovementEvents.onStopWalking(this);
        } else if (isCurrentlyWalking) {
            this.arc$isWalking = true;
            MovementEvents.onStartWalking(this);
        }
        if (this.arc$isSprinting && this.isSprinting()) {
            this.arc$sprintingDistance += distance;
            MovementEvents.onSprint(this, (int)(this.arc$sprintingDistance * 100.0f));
        } else if (this.arc$isSprinting) {
            this.arc$isSprinting = false;
            MovementEvents.onStopSprinting(this);
        } else if (this.isSprinting()) {
            this.arc$isSprinting = true;
            MovementEvents.onStartSprinting(this);
        }
        if (this.arc$isHorseRiding && (entity = this.getRootVehicle()) instanceof Horse && (horse = (Horse)entity).isSaddled() && horse.isTamed()) {
            boolean isCurrentlyRiding = horse.walkDist > this.arc$horseRidingDistance;
            float horseRidingDistance = horse.walkDist - this.arc$horseRidingDistance;
            if (isCurrentlyRiding) {
                this.arc$horseRidingDistance += horseRidingDistance;
                MovementEvents.onHorseRide(this, (int)(this.arc$horseRidingDistance * 100.0f));
            }
        } else if (this.arc$isHorseRiding) {
            this.arc$isHorseRiding = false;
            MovementEvents.onStopHorseRiding(this);
        } else {
            Horse horse2;
            Entity entity2 = this.getRootVehicle();
            if (entity2 instanceof Horse && (horse2 = (Horse)entity2).isSaddled() && horse2.isTamed()) {
                this.arc$isHorseRiding = true;
                this.arc$horseRidingDistance = 0.0f;
                horse2.walkDist = 0.0f;
                MovementEvents.onStartHorseRiding(this);
            }
        }
        if (this.arc$isCrouching && this.isCrouching()) {
            this.arc$crouchingDistance += distance;
            MovementEvents.onCrouch(this, (int)(this.arc$crouchingDistance * 100.0f));
        } else if (this.arc$isCrouching) {
            this.arc$isCrouching = false;
            MovementEvents.onStopCrouching(this);
        } else if (this.isCrouching()) {
            this.arc$isCrouching = true;
            MovementEvents.onStartCrouching(this);
        }
        if (this.arc$isElytraFlying && this.isFallFlying()) {
            MovementEvents.onElytraFly(this, (int)this.arc$elytraFlyingDistance);
        } else if (this.arc$isElytraFlying) {
            this.arc$isElytraFlying = false;
            MovementEvents.onStopElytraFlying(this);
        } else if (this.isFallFlying()) {
            this.arc$isElytraFlying = true;
            MovementEvents.onStartElytraFlying(this);
        }
        if (this.arc$getServerPlayer().containerMenu instanceof GrindstoneMenu) {
            if (this.arc$isGrinding) {
                boolean firstSlot = false;
                boolean secondSlot = false;
                for (Slot slot : this.containerMenu.slots) {
                    if (slot.getItem().getItem() instanceof AirItem || slot.container instanceof Inventory) continue;
                    if (slot.getContainerSlot() == 0) {
                        firstSlot = true;
                    }
                    if (slot.getContainerSlot() != 1) continue;
                    secondSlot = true;
                }
                if (!firstSlot && !secondSlot) {
                    PlayerEvents.onGrindItem(this);
                }
            }
            boolean firstSlot = false;
            boolean secondSlot = false;
            for (Slot slot : this.containerMenu.slots) {
                if (slot.getItem().getItem() instanceof AirItem || slot.container instanceof Inventory) continue;
                if (slot.getContainerSlot() == 0) {
                    firstSlot = true;
                }
                if (slot.getContainerSlot() != 1) continue;
                secondSlot = true;
            }
            this.arc$isGrinding = firstSlot && secondSlot;
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"awardStat(Lnet/minecraft/stats/Stat;I)V"})
    public void awardStat(Stat<?> stat, int amount, CallbackInfo ci) {
        int previousAmount = 0;
        boolean found = false;
        for (StatData statData : this.arc$getStatData()) {
            if (!statData.getStat().equals(stat)) continue;
            previousAmount = statData.getAmount();
            statData.addAmount(amount);
            found = true;
            break;
        }
        if (!found) {
            this.arc$addStatData(new StatData(stat, amount));
        }
        StatEvents.onAwardStat(this, stat, previousAmount, previousAmount + amount);
    }

    @Inject(at={@At(value="TAIL")}, method={"onEffectAdded(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/Entity;)V"})
    public void onEffectAdded(MobEffectInstance effect, @Nullable Entity entity, CallbackInfo ci) {
    }

    @Inject(at={@At(value="TAIL")}, method={"onEnchantmentPerformed(Lnet/minecraft/world/item/ItemStack;I)V"})
    public void onEnchantmentPerformed(ItemStack itemStack, int level, CallbackInfo ci) {
        PlayerEvents.onEnchantItem(this, itemStack, level);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z", shift=At.Shift.BEFORE)}, method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, cancellable=true)
    public void hurt(DamageSource damageSource, float f, CallbackInfoReturnable<Boolean> cir) {
        Object actionResult;
        ArcServerPlayer arcServerPlayer;
        Player entity = this.arc$getPlayer();
        if (entity instanceof ArcServerPlayer) {
            arcServerPlayer = (ArcServerPlayer)entity;
            actionResult = new ActionDataBuilder(arcServerPlayer, ActionType.GET_HURT).withData(ActionDataType.DAMAGE_SOURCE, damageSource).withData(ActionDataType.DAMAGE_AMOUNT, Float.valueOf(f)).build().sendToAction();
            if (((ActionResult)actionResult).shouldCancelAction()) {
                f = 0.0f;
            }
            if (((ActionResult)actionResult).getDamageModifier() != 1.0f) {
                f *= ((ActionResult)actionResult).getDamageModifier();
            }
        }
        if ((actionResult = damageSource.getEntity()) instanceof ArcServerPlayer) {
            arcServerPlayer = (ArcServerPlayer)actionResult;
            if (((ActionResult)(actionResult = new ActionDataBuilder(arcServerPlayer, ActionType.HURT_PLAYER).withData(ActionDataType.ENTITY, entity).withData(ActionDataType.DAMAGE_AMOUNT, Float.valueOf(f)).build().sendToAction())).shouldCancelAction()) {
                f = 0.0f;
            }
            if (((ActionResult)actionResult).getDamageModifier() != 1.0f) {
                f *= ((ActionResult)actionResult).getDamageModifier();
            }
        }
        cir.setReturnValue((Object)super.hurt(damageSource, f));
    }

    @Inject(at={@At(value="HEAD")}, method={"triggerRecipeCrafted(Lnet/minecraft/world/item/crafting/RecipeHolder;Ljava/util/List;)V"})
    public void mixinTriggerRecipeCrafted(RecipeHolder<?> recipeHolder, List<ItemStack> list, CallbackInfo ci) {
        Level level = this.level();
        PlayerEvents.onCraftItem(this, recipeHolder.value(), recipeHolder.value().getResultItem((HolderLookup.Provider)level.registryAccess()), level);
    }

    @Inject(at={@At(value="TAIL")}, method={"restoreFrom(Lnet/minecraft/server/level/ServerPlayer;Z)V"})
    public void restoreFrom(ServerPlayer oldPlayer, boolean alive, CallbackInfo ci) {
        if (oldPlayer instanceof ArcServerPlayer) {
            ArcServerPlayer arcServerPlayer = (ArcServerPlayer)oldPlayer;
            this.arc$actionHolders = arcServerPlayer.arc$getActionHoldersMap();
            this.arc$statData = arcServerPlayer.arc$getStatData();
            this.arc$lastDistanceInCm = arcServerPlayer.arc$getLastDistancesInCm();
            this.arc$lastRemainderInCm = arcServerPlayer.arc$getLastRemaindersInCm();
            this.arc$isSwimming = arcServerPlayer.arc$isSwimming();
            this.arc$swimmingDistanceInCm = arcServerPlayer.arc$getSwimmingDistanceInCm();
            this.arc$isWalking = arcServerPlayer.arc$isWalking();
            this.arc$walkingDistance = arcServerPlayer.arc$getWalkingDistance();
            this.arc$isSprinting = arcServerPlayer.arc$isSprinting();
            this.arc$sprintingDistance = arcServerPlayer.arc$getSprintingDistance();
            this.arc$isCrouching = arcServerPlayer.arc$isCrouching();
            this.arc$crouchingDistance = arcServerPlayer.arc$getCrouchingDistance();
            this.arc$isElytraFlying = arcServerPlayer.arc$isElytraFlying();
            this.arc$elytraFlyingDistance = arcServerPlayer.arc$getElytraFlyingDistance();
            this.arc$isGrinding = arcServerPlayer.arc$isGrinding();
            this.arc$isHorseRiding = arcServerPlayer.arc$isHorseRiding();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/server/level/ServerLevel;Lcom/mojang/authlib/GameProfile;Lnet/minecraft/server/level/ClientInformation;)V"})
    public void readAdditionalSaveData(MinecraftServer minecraftServer, ServerLevel serverLevel, GameProfile gameProfile, ClientInformation clientInformation, CallbackInfo ci) {
        ServerPlayer serverPlayer = (ServerPlayer)this;
        if (serverPlayer instanceof ArcPlayer) {
            ArcPlayer arcPlayer = (ArcPlayer)serverPlayer;
            arcPlayer.arc$addActionHolders(PlayerActionHolderManager.getInstance().getPlayerActionHoldersList());
        }
    }
}

