/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.networking;

import com.daqem.arc.api.action.holder.IActionHolder;
import com.daqem.arc.api.action.holder.serializer.IActionHolderSerializer;
import com.daqem.arc.client.gui.holder.ActionHoldersScreen;
import com.daqem.arc.networking.ArcNetworking;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ClientboundActionHoldersScreenPacket
implements CustomPacketPayload {
    private final List<IActionHolder> actionHolders;
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundActionHoldersScreenPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ClientboundActionHoldersScreenPacket>(){

        @NotNull
        public ClientboundActionHoldersScreenPacket decode(RegistryFriendlyByteBuf buf) {
            return new ClientboundActionHoldersScreenPacket(buf);
        }

        public void encode(RegistryFriendlyByteBuf buf, ClientboundActionHoldersScreenPacket packet) {
            buf.writeCollection(packet.actionHolders, (friendlyByteBuf, action) -> IActionHolderSerializer.toNetwork(action, (RegistryFriendlyByteBuf)friendlyByteBuf));
        }
    };

    public ClientboundActionHoldersScreenPacket(List<IActionHolder> actionHolders) {
        this.actionHolders = actionHolders;
    }

    public ClientboundActionHoldersScreenPacket(RegistryFriendlyByteBuf buf) {
        this.actionHolders = buf.readList(friendlyByteBuf1 -> IActionHolderSerializer.fromNetwork((RegistryFriendlyByteBuf)friendlyByteBuf1));
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ArcNetworking.CLIENTBOUND_ACTION_HOLDERS_SCREEN_PACKET;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleClientSide(ClientboundActionHoldersScreenPacket packet, NetworkManager.PacketContext context) {
        Minecraft.getInstance().setScreen((Screen)new ActionHoldersScreen(packet.actionHolders));
    }
}

