/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.networking;

import com.daqem.arc.api.action.holder.ActionHolderManager;
import com.daqem.arc.api.action.holder.IActionHolder;
import com.daqem.arc.api.action.holder.serializer.IActionHolderSerializer;
import com.daqem.arc.networking.ArcNetworking;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ClientboundUpdateActionHoldersPacket
implements CustomPacketPayload {
    private final List<IActionHolder> actionHolders;
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundUpdateActionHoldersPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ClientboundUpdateActionHoldersPacket>(){

        @NotNull
        public ClientboundUpdateActionHoldersPacket decode(RegistryFriendlyByteBuf buf) {
            return new ClientboundUpdateActionHoldersPacket(buf);
        }

        public void encode(RegistryFriendlyByteBuf buf, ClientboundUpdateActionHoldersPacket packet) {
            buf.writeCollection(packet.actionHolders, (friendlyByteBuf, action) -> IActionHolderSerializer.toNetwork(action, (RegistryFriendlyByteBuf)friendlyByteBuf));
        }
    };

    public ClientboundUpdateActionHoldersPacket(List<IActionHolder> actionHolders) {
        this.actionHolders = actionHolders;
    }

    public ClientboundUpdateActionHoldersPacket(RegistryFriendlyByteBuf friendlyByteBuf) {
        this.actionHolders = friendlyByteBuf.readList(friendlyByteBuf1 -> IActionHolderSerializer.fromNetwork((RegistryFriendlyByteBuf)friendlyByteBuf1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleClientSide(ClientboundUpdateActionHoldersPacket packet, NetworkManager.PacketContext context) {
        if (!Minecraft.getInstance().isLocalServer()) {
            ActionHolderManager.getInstance().registerActionHolders(packet.actionHolders);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ArcNetworking.CLIENTBOUND_UPDATE_ACTION_HOLDERS;
    }
}

