/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.networking;

import com.daqem.arc.api.action.IAction;
import com.daqem.arc.api.action.holder.ActionHolderManager;
import com.daqem.arc.api.action.serializer.IActionSerializer;
import com.daqem.arc.networking.ArcNetworking;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ClientboundUpdateActionsPacket
implements CustomPacketPayload {
    private final List<IAction> actions;
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundUpdateActionsPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ClientboundUpdateActionsPacket>(){

        @NotNull
        public ClientboundUpdateActionsPacket decode(RegistryFriendlyByteBuf buf) {
            return new ClientboundUpdateActionsPacket(buf);
        }

        public void encode(RegistryFriendlyByteBuf buf, ClientboundUpdateActionsPacket packet) {
            buf.writeCollection(packet.actions, (friendlyByteBuf, action) -> IActionSerializer.toNetwork(action, (RegistryFriendlyByteBuf)friendlyByteBuf));
        }
    };

    public ClientboundUpdateActionsPacket(List<IAction> actions) {
        this.actions = actions;
    }

    public ClientboundUpdateActionsPacket(RegistryFriendlyByteBuf friendlyByteBuf) {
        this.actions = friendlyByteBuf.readList(object -> IActionSerializer.fromNetwork((RegistryFriendlyByteBuf)object));
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ArcNetworking.CLIENTBOUND_UPDATE_ACTIONS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleClientSide(ClientboundUpdateActionsPacket packet, NetworkManager.PacketContext context) {
        if (!Minecraft.getInstance().isLocalServer()) {
            ActionHolderManager.getInstance().registerActions(packet.actions);
        }
    }
}

