/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.condition.movement;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.data.type.ActionDataType;
import com.daqem.arc.api.condition.AbstractCondition;
import com.daqem.arc.api.condition.serializer.IConditionSerializer;
import com.daqem.arc.api.condition.type.ConditionType;
import com.daqem.arc.api.condition.type.IConditionType;
import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.arc.api.player.ArcServerPlayer;
import com.google.gson.JsonObject;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class DistanceCondition
extends AbstractCondition {
    private final int distanceInBlocks;

    public DistanceCondition(boolean inverted, int distanceInBlocks) {
        super(inverted);
        this.distanceInBlocks = distanceInBlocks;
    }

    @Override
    public Component getDescription() {
        return this.getDescription(this.distanceInBlocks);
    }

    @Override
    public boolean isMet(ActionData actionData) {
        ArcPlayer arcPlayer = actionData.getPlayer();
        if (arcPlayer instanceof ArcServerPlayer) {
            ArcServerPlayer serverPlayer = (ArcServerPlayer)arcPlayer;
            Integer totalDistanceMovedInCm = actionData.getData(ActionDataType.DISTANCE_IN_CM);
            if (totalDistanceMovedInCm != null) {
                totalDistanceMovedInCm = totalDistanceMovedInCm + serverPlayer.arc$getLastRemainderInCm(this);
                double lastTotalDistanceMovedInCm = serverPlayer.arc$getLastDistanceInCm(this);
                double currentDistanceMovedInCm = (double)totalDistanceMovedInCm.intValue() - lastTotalDistanceMovedInCm;
                double currentDistanceMovedInBlocks = currentDistanceMovedInCm / 100.0;
                if (currentDistanceMovedInBlocks >= (double)this.distanceInBlocks) {
                    serverPlayer.arc$setLastDistanceInCm(this, totalDistanceMovedInCm);
                    return true;
                }
                serverPlayer.arc$setLastRemainderInCm(this, (int)(currentDistanceMovedInBlocks % (double)this.distanceInBlocks) * 100);
            }
        }
        return false;
    }

    public IConditionType<?> getType() {
        return ConditionType.DISTANCE;
    }

    public int getDistanceInBlocks() {
        return this.distanceInBlocks;
    }

    public static class Serializer
    implements IConditionSerializer<DistanceCondition> {
        @Override
        public DistanceCondition fromJson(ResourceLocation location, JsonObject jsonObject, boolean inverted) {
            return new DistanceCondition(inverted, GsonHelper.getAsInt((JsonObject)jsonObject, (String)"distance_in_blocks"));
        }

        @Override
        public DistanceCondition fromNetwork(ResourceLocation location, RegistryFriendlyByteBuf friendlyByteBuf, boolean inverted) {
            return new DistanceCondition(inverted, friendlyByteBuf.readVarInt());
        }

        @Override
        public void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, DistanceCondition type) {
            IConditionSerializer.super.toNetwork(friendlyByteBuf, type);
            friendlyByteBuf.writeVarInt(type.distanceInBlocks);
        }
    }
}

