/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.mixin;

import com.daqem.arc.Arc;
import com.daqem.arc.api.player.ArcServerPlayer;
import com.daqem.arc.event.triggers.PlayerEvents;
import com.daqem.arc.player.brewing.BrewingStandData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BrewingStandBlockEntity.class})
public abstract class MixinBrewingStandBlockEntity {
    @Inject(at={@At(value="HEAD")}, method={"serverTick(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/BrewingStandBlockEntity;)V"})
    private static void serverTick(Level level, BlockPos blockPos, BlockState blockState, BrewingStandBlockEntity brewingStandBlockEntity, CallbackInfo info) {
        if (!Arc.BREWING_STANDS.containsKey(blockPos)) {
            Arc.BREWING_STANDS.put(blockPos, new BrewingStandData(brewingStandBlockEntity));
        }
        BrewingStandData brewingStandData = Arc.BREWING_STANDS.get(blockPos);
        for (int i = 0; i < 3; ++i) {
            if (brewingStandBlockEntity.getItem(i).isEmpty()) {
                if (brewingStandData.getBrewingStandItemOwner(i) == null) continue;
                brewingStandData.removeBrewingStandItemOwner(i);
                continue;
            }
            if (brewingStandData.getBrewingStandItemOwner(i) != null || brewingStandData.getLastPlayerToInteract() == null) continue;
            brewingStandData.addBrewingStandItemOwner(i, brewingStandData.getLastPlayerToInteract());
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"doBrew(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/NonNullList;)V"})
    private static void doBrew(Level level, BlockPos blockPos, NonNullList<ItemStack> nonNullList, CallbackInfo ci) {
        BrewingStandData brewingStandData;
        if (Arc.BREWING_STANDS.containsKey(blockPos) && (brewingStandData = Arc.BREWING_STANDS.get(blockPos)).getBrewingStandItemOwners().size() == nonNullList.stream().filter(itemStack -> itemStack.getItem() instanceof PotionItem).toList().size()) {
            int i = 0;
            for (ArcServerPlayer player : brewingStandData.getBrewingStandItemOwners().values()) {
                PlayerEvents.onBrewPotion(player, (ItemStack)nonNullList.get(i), blockPos, level);
                ++i;
            }
        }
    }
}

