/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.mixin;

import com.daqem.arc.api.action.result.ActionResult;
import com.daqem.arc.api.player.ArcServerPlayer;
import com.daqem.arc.event.triggers.PlayerEvents;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class MixinItemStack {
    @Shadow
    public abstract Item getItem();

    @Shadow
    public abstract ItemUseAnimation getUseAnimation();

    @Inject(at={@At(value="HEAD")}, method={"finishUsingItem(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/item/ItemStack;"})
    private void finishUsingItem(Level level, LivingEntity entity, CallbackInfoReturnable<ItemStack> cir) {
        if (entity instanceof ArcServerPlayer) {
            ArcServerPlayer player = (ArcServerPlayer)entity;
            if (this.getUseAnimation() == ItemUseAnimation.DRINK) {
                PlayerEvents.onPlayerDrink(player, this.arc$getItemStack());
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"hurtAndBreak(ILnet/minecraft/server/level/ServerLevel;Lnet/minecraft/server/level/ServerPlayer;Ljava/util/function/Consumer;)V"}, cancellable=true)
    private void hurtAndBreak(int i, ServerLevel serverLevel, ServerPlayer serverPlayer, Consumer<Item> consumer, CallbackInfo ci) {
        if (serverPlayer instanceof ArcServerPlayer) {
            ArcServerPlayer player = (ArcServerPlayer)serverPlayer;
            ItemStack copy = this.arc$getItemStack().copy();
            if (copy.isDamageableItem() && !serverPlayer.hasInfiniteMaterials()) {
                ActionResult actionResult;
                if (i > 0 && (i = EnchantmentHelper.processDurabilityChange((ServerLevel)serverLevel, (ItemStack)copy, (int)i)) <= 0) {
                    return;
                }
                int j = copy.getDamageValue() + i;
                copy.setDamageValue(j);
                if (j >= copy.getMaxDamage() && (actionResult = PlayerEvents.onPlayerHurtItem(player, this.arc$getItemStack())).shouldCancelAction()) {
                    ci.cancel();
                }
            }
        }
    }

    @Unique
    private ItemStack arc$getItemStack() {
        return (ItemStack)this;
    }
}

