/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.networking;

import com.daqem.arc.api.action.IAction;
import com.daqem.arc.api.action.serializer.IActionSerializer;
import com.daqem.arc.networking.ArcNetworking;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import org.jetbrains.annotations.NotNull;

public class ClientboundUpdateActionsPacket
implements CustomPacketPayload {
    private final List<IAction> actions;
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundUpdateActionsPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ClientboundUpdateActionsPacket>(){

        @NotNull
        public ClientboundUpdateActionsPacket decode(RegistryFriendlyByteBuf buf) {
            return new ClientboundUpdateActionsPacket(buf);
        }

        public void encode(RegistryFriendlyByteBuf buf, ClientboundUpdateActionsPacket packet) {
            buf.writeCollection(packet.actions, (friendlyByteBuf, action) -> IActionSerializer.toNetwork(action, (RegistryFriendlyByteBuf)friendlyByteBuf));
        }
    };

    public ClientboundUpdateActionsPacket(List<IAction> actions) {
        this.actions = actions;
    }

    public ClientboundUpdateActionsPacket(RegistryFriendlyByteBuf friendlyByteBuf) {
        this.actions = friendlyByteBuf.readList(object -> IActionSerializer.fromNetwork((RegistryFriendlyByteBuf)object));
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ArcNetworking.CLIENTBOUND_UPDATE_ACTIONS;
    }

    public List<IAction> getActions() {
        return this.actions;
    }
}

