/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.api.reward.serializer;

import com.daqem.arc.api.reward.IReward;
import com.daqem.arc.api.reward.type.IRewardType;
import com.daqem.arc.data.serializer.ArcSerializer;
import com.daqem.arc.registry.ArcRegistry;
import com.google.gson.JsonObject;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public interface IRewardSerializer<T extends IReward>
extends ArcSerializer {
    public T fromJson(JsonObject var1, double var2, int var4);

    public T fromNetwork(RegistryFriendlyByteBuf var1, double var2, int var4);

    public static IReward fromNetwork(RegistryFriendlyByteBuf friendlyByteBuf) {
        ResourceLocation resourceLocation = friendlyByteBuf.readResourceLocation();
        ResourceLocation resourceLocation2 = friendlyByteBuf.readResourceLocation();
        return ((IRewardType)ArcRegistry.REWARD.getOptional(resourceLocation).orElseThrow(() -> new IllegalArgumentException("Unknown reward serializer " + String.valueOf(resourceLocation)))).getSerializer().fromNetwork(resourceLocation2, friendlyByteBuf);
    }

    public static <T extends IReward> void toNetwork(T reward, RegistryFriendlyByteBuf friendlyByteBuf, ResourceLocation location) {
        friendlyByteBuf.writeResourceLocation(ArcRegistry.REWARD.getKey(reward.getType()));
        friendlyByteBuf.writeResourceLocation(location);
        reward.getSerializer().toNetwork(friendlyByteBuf, reward);
    }

    default public T fromJson(ResourceLocation location, JsonObject jsonObject) {
        return this.fromJson(jsonObject, GsonHelper.getAsDouble((JsonObject)jsonObject, (String)"chance", (double)100.0), GsonHelper.getAsInt((JsonObject)jsonObject, (String)"priority", (int)1));
    }

    default public T fromNetwork(ResourceLocation location, RegistryFriendlyByteBuf friendlyByteBuf) {
        return this.fromNetwork(friendlyByteBuf, friendlyByteBuf.readDouble(), friendlyByteBuf.readInt());
    }

    default public void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, T type) {
        friendlyByteBuf.writeDouble(type.getChance());
        friendlyByteBuf.writeInt(type.getPriority());
    }
}

