/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data;

import com.daqem.arc.Arc;
import com.daqem.arc.api.action.IAction;
import com.daqem.arc.api.action.holder.ActionHolderManager;
import com.daqem.arc.api.action.type.IActionType;
import com.daqem.arc.registry.ArcRegistry;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class ActionManager
extends SimplePreparableReloadListener<List<IAction>> {
    @NotNull
    protected List<IAction> prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        Map<ResourceLocation, Resource> resourceMap = resourceManager.listResources("arc", resourceLocation -> resourceLocation.getPath().endsWith(".json")).entrySet().stream().collect(Collectors.toMap(entry -> ResourceLocation.fromNamespaceAndPath((String)((ResourceLocation)entry.getKey()).getNamespace(), (String)((ResourceLocation)entry.getKey()).getPath().substring(0, ((ResourceLocation)entry.getKey()).getPath().length() - ".json".length()).substring("arc/".length())), Map.Entry::getValue));
        HashMap<ResourceLocation, JsonObject> map = new HashMap<ResourceLocation, JsonObject>();
        for (Map.Entry<ResourceLocation, Resource> entry2 : resourceMap.entrySet()) {
            ResourceLocation location = entry2.getKey();
            try {
                JsonObject jsonElement = GsonHelper.parse((Reader)entry2.getValue().openAsReader());
                map.put(location, jsonElement);
            }
            catch (Exception runtimeException) {
                Arc.LOGGER.error("Parsing error loading action {}", (Object)location, (Object)runtimeException);
            }
        }
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (!Arc.isDebugEnvironment()) {
            map.entrySet().removeIf(entry -> ((ResourceLocation)entry.getKey()).getNamespace().equals("debug"));
        }
        for (Map.Entry entry3 : map.entrySet()) {
            ResourceLocation location = (ResourceLocation)entry3.getKey();
            try {
                IAction action = ActionManager.fromJson(location, GsonHelper.convertToJsonObject((JsonElement)((JsonElement)entry3.getValue()), (String)"top element"));
                actions.add(action);
            }
            catch (JsonParseException | IllegalArgumentException runtimeException) {
                Arc.LOGGER.error("Parsing error loading action {}", (Object)location, (Object)runtimeException);
            }
        }
        return actions;
    }

    protected void apply(List<IAction> actions, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        ActionHolderManager actionHolderManager = ActionHolderManager.getInstance();
        actionHolderManager.clearAllActions();
        actionHolderManager.registerActions(actions);
        Arc.LOGGER.info("Loaded {} actions", (Object)actions.size());
    }

    public static IAction fromJson(ResourceLocation location, JsonObject jsonObject) {
        String type = GsonHelper.getAsString((JsonObject)jsonObject, (String)"type");
        return ((IActionType)ArcRegistry.ACTION.getOptional(ResourceLocation.parse((String)type)).orElseThrow(() -> new JsonSyntaxException("Invalid or unsupported action type '" + type + "'"))).getSerializer().fromJson(location, jsonObject);
    }
}

