/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data;

import com.daqem.arc.Arc;
import com.daqem.arc.api.action.holder.ActionHolderManager;
import com.daqem.arc.api.action.holder.IActionHolder;
import com.daqem.arc.api.action.holder.type.ActionHolderType;
import com.daqem.arc.api.player.holder.PlayerActionHolder;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class PlayerActionHolderManager
extends SimplePreparableReloadListener<IActionHolder> {
    private static PlayerActionHolderManager instance;
    private ImmutableMap<ResourceLocation, IActionHolder> playerActionHolders = ImmutableMap.of();

    public PlayerActionHolderManager() {
        instance = this;
    }

    @NotNull
    protected IActionHolder prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        ResourceLocation location = Arc.getId("player");
        return new PlayerActionHolder(location);
    }

    protected void apply(IActionHolder actionHolder, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        ActionHolderManager actionHolderManager = ActionHolderManager.getInstance();
        actionHolderManager.clearAllActionHoldersForType(ActionHolderType.PLAYER_ACTION_TYPE);
        this.playerActionHolders = ImmutableMap.of((Object)actionHolder.getLocation(), (Object)actionHolder);
        actionHolderManager.registerActionHolders(List.of(actionHolder));
    }

    public static PlayerActionHolderManager getInstance() {
        return instance;
    }

    public List<IActionHolder> getPlayerActionHoldersList() {
        return new ArrayList<IActionHolder>((Collection<IActionHolder>)this.playerActionHolders.values());
    }
}

