/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.condition.item;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.data.type.ActionDataType;
import com.daqem.arc.api.condition.AbstractCondition;
import com.daqem.arc.api.condition.serializer.IConditionSerializer;
import com.daqem.arc.api.condition.type.ConditionType;
import com.daqem.arc.api.condition.type.IConditionType;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ItemsCondition
extends AbstractCondition {
    private final List<Item> items;
    private final List<TagKey<Item>> itemTags;

    public ItemsCondition(boolean inverted, List<Item> items, List<TagKey<Item>> itemTags) {
        super(inverted);
        this.items = items;
        this.itemTags = itemTags;
    }

    @Override
    public Component getDescription() {
        return this.getDescription(this.items.stream().map(Item::getName).toArray(Component[]::new), this.itemTags.stream().map(TagKey::location).toArray(ResourceLocation[]::new));
    }

    @Override
    public boolean isMet(ActionData actionData) {
        Item item;
        ItemStack itemStack = actionData.getData(ActionDataType.ITEM_STACK);
        if (itemStack == null && (item = actionData.getData(ActionDataType.ITEM)) != null) {
            itemStack = item.getDefaultInstance();
        }
        return itemStack != null && (this.isItem(itemStack) || this.isItemByTag(itemStack));
    }

    public IConditionType<?> getType() {
        return ConditionType.ITEMS;
    }

    private boolean isItem(ItemStack itemStack) {
        return this.items.contains(itemStack.getItem());
    }

    private boolean isItemByTag(ItemStack itemStack) {
        return this.itemTags.stream().anyMatch(arg_0 -> ((ItemStack)itemStack).is(arg_0));
    }

    public List<Item> getItems() {
        return this.items;
    }

    public List<TagKey<Item>> getItemTags() {
        return this.itemTags;
    }

    public List<ItemStack> getItemStacks(RegistryAccess registryAccess) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (Item item : this.items) {
            itemStacks.add(new ItemStack((ItemLike)item));
        }
        for (TagKey tagKey : this.itemTags) {
            registryAccess.lookupOrThrow(Registries.ITEM).get(tagKey).ifPresent(holders -> {
                for (Holder holder : holders) {
                    itemStacks.add(new ItemStack((ItemLike)holder.value()));
                }
            });
        }
        return itemStacks;
    }

    public static class Serializer
    implements IConditionSerializer<ItemsCondition> {
        @Override
        public ItemsCondition fromJson(ResourceLocation location, JsonObject jsonObject, boolean inverted) {
            return new ItemsCondition(inverted, this.getItems(jsonObject, "items"), this.getItemTags(jsonObject, "items"));
        }

        @Override
        public ItemsCondition fromNetwork(ResourceLocation location, RegistryFriendlyByteBuf friendlyByteBuf, boolean inverted) {
            int i;
            int itemCount = friendlyByteBuf.readVarInt();
            int tagCount = friendlyByteBuf.readVarInt();
            ArrayList<Item> items = new ArrayList<Item>();
            ArrayList<TagKey<Item>> itemTags = new ArrayList<TagKey<Item>>();
            for (i = 0; i < itemCount; ++i) {
                items.add((Item)ByteBufCodecs.registry((ResourceKey)Registries.ITEM).decode((Object)friendlyByteBuf));
            }
            for (i = 0; i < tagCount; ++i) {
                itemTags.add((TagKey<Item>)TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)friendlyByteBuf.readResourceLocation()));
            }
            return new ItemsCondition(inverted, items, itemTags);
        }

        @Override
        public void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, ItemsCondition type) {
            IConditionSerializer.super.toNetwork(friendlyByteBuf, type);
            friendlyByteBuf.writeVarInt(type.items.size());
            friendlyByteBuf.writeVarInt(type.itemTags.size());
            type.items.forEach(item -> ByteBufCodecs.registry((ResourceKey)Registries.ITEM).encode((Object)friendlyByteBuf, item));
            type.itemTags.forEach(tag -> friendlyByteBuf.writeResourceLocation(tag.location()));
        }
    }
}

