/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.serializer;

import com.daqem.arc.api.action.holder.type.IActionHolderType;
import com.daqem.arc.data.serializer.ElementConverter;
import com.daqem.arc.registry.ArcRegistry;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public interface ArcSerializer {
    default public ResourceLocation getResourceLocation(JsonObject jsonObject, String elementName) {
        return ResourceLocation.parse((String)this.getString(jsonObject, elementName));
    }

    default public ItemStack getItemStack(JsonElement element) {
        return (ItemStack)((Pair)ItemStack.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).result().orElseThrow(() -> new JsonParseException("Invalid item stack"))).getFirst();
    }

    default public IActionHolderType<?> getHolderType(JsonObject jsonObject, String elementName) {
        return new ElementConverter(ArcRegistry.ACTION_HOLDER).convertToElement(this.getString(jsonObject, elementName));
    }

    default public Item getItem(JsonObject jsonObject, String elementName) {
        return (Item)new ElementConverter(BuiltInRegistries.ITEM).convertToElement(this.getString(jsonObject, elementName));
    }

    default public Block getBlock(JsonObject jsonObject, String elementName) {
        return (Block)new ElementConverter(BuiltInRegistries.BLOCK).convertToElement(this.getString(jsonObject, elementName));
    }

    default public MobEffect getMobEffect(JsonObject jsonObject, String elementName) {
        return (MobEffect)new ElementConverter(BuiltInRegistries.MOB_EFFECT).convertToElement(this.getString(jsonObject, elementName));
    }

    default public EntityType<?> getEntityType(JsonObject jsonObject, String elementName) {
        return (EntityType)new ElementConverter(BuiltInRegistries.ENTITY_TYPE).convertToElement(this.getString(jsonObject, elementName));
    }

    default public String getString(JsonObject jsonObject, String elementName) {
        return GsonHelper.getAsString((JsonObject)jsonObject, (String)elementName);
    }

    default public List<String> getStrings(JsonObject jsonObject, String elementName) {
        return StreamSupport.stream(GsonHelper.getAsJsonArray((JsonObject)jsonObject, (String)elementName).spliterator(), false).map(JsonElement::getAsString).collect(Collectors.toList());
    }

    default public <E> List<E> getElementsFromJson(Registry<E> registry, JsonObject jsonObject, String elementName) {
        return new ElementConverter<E>(registry).convertToElements(this.getStrings(jsonObject, elementName));
    }

    default public <E> List<TagKey<E>> getTagKeysFromJson(Registry<E> registry, JsonObject jsonObject, String elementName) {
        return new ElementConverter<E>(registry).convertToElementTags(this.getStrings(jsonObject, elementName));
    }

    default public List<Block> getBlocks(JsonObject jsonObject, String elementName) {
        return this.getElementsFromJson((Registry)BuiltInRegistries.BLOCK, jsonObject, elementName);
    }

    default public List<TagKey<Block>> getBlockTags(JsonObject jsonObject, String elementName) {
        return this.getTagKeysFromJson((Registry)BuiltInRegistries.BLOCK, jsonObject, elementName);
    }

    default public List<Item> getItems(JsonObject jsonObject, String elementName) {
        return this.getElementsFromJson((Registry)BuiltInRegistries.ITEM, jsonObject, elementName);
    }

    default public List<TagKey<Item>> getItemTags(JsonObject jsonObject, String elementName) {
        return this.getTagKeysFromJson((Registry)BuiltInRegistries.ITEM, jsonObject, elementName);
    }

    default public List<EntityType<?>> getEntityTypes(JsonObject jsonObject, String elementName) {
        return this.getElementsFromJson((Registry)BuiltInRegistries.ENTITY_TYPE, jsonObject, elementName);
    }

    default public InteractionHand getHand(JsonObject jsonObject, String elementName) {
        InteractionHand hand;
        String handName = this.getString(jsonObject, elementName);
        try {
            hand = InteractionHand.valueOf((String)handName);
        }
        catch (IllegalArgumentException e) {
            throw new JsonParseException("Invalid hand, expected to find a valid hand ('MAIN_HAND' or 'OFF_HAND').");
        }
        return hand;
    }

    @Nullable
    default public InteractionHand getOptionalHand(JsonObject jsonObject, String elementName) {
        if (jsonObject.has(elementName)) {
            return this.getHand(jsonObject, elementName);
        }
        return null;
    }

    default public MobEffectCategory getMobEffectCategory(JsonObject jsonObject, String elementName) {
        MobEffectCategory effectCategory;
        String effectCategoryName = this.getString(jsonObject, elementName);
        try {
            effectCategory = MobEffectCategory.valueOf((String)effectCategoryName);
        }
        catch (IllegalArgumentException e) {
            throw new JsonParseException("Invalid effect_category, expected to find a valid effect category ('BENEFICIAL', 'HARMFUL' or 'NEUTRAL').");
        }
        return effectCategory;
    }

    default public ResourceKey<Level> getDimension(JsonObject jsonObject, String elementName) {
        ResourceKey dimension;
        String dimensionName = this.getString(jsonObject, elementName);
        try {
            dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)dimensionName));
        }
        catch (IllegalArgumentException e) {
            throw new JsonParseException("Invalid dimension, expected to find a valid dimension.");
        }
        return dimension;
    }
}

