/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.serializer;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ElementConverter<T> {
    private final Registry<T> registry;

    public ElementConverter(Registry<T> registry) {
        this.registry = registry;
    }

    public List<T> convertToElements(List<String> elements) {
        return elements.stream().filter(elementLoc -> !elementLoc.startsWith("#")).filter(elementLoc -> elementLoc.contains(":")).map(this.convertToElement()).collect(Collectors.toList());
    }

    public List<TagKey<T>> convertToElementTags(List<String> elementTags) {
        return elementTags.stream().filter(elementLoc -> elementLoc.startsWith("#")).filter(elementLoc -> elementLoc.contains(":")).map(this.replaceHashAndConvertToTag()).collect(Collectors.toList());
    }

    public T convertToElement(String element) {
        T type = this.registry.get(ResourceLocation.parse((String)element)).map(Holder.Reference::value).orElse(null);
        if (type instanceof Block && element.equals("minecraft:air")) {
            return type;
        }
        if (type instanceof Item && element.equals("minecraft:air")) {
            return type;
        }
        if (type instanceof MobEffect && element.equals("minecraft:luck")) {
            return type;
        }
        if (type instanceof EntityType && element.equals("minecraft:pig")) {
            return type;
        }
        if (type == this.registry.get(ResourceLocation.parse((String)"x")) || type == null) {
            throw new IllegalArgumentException(element + " could not be found in registry " + String.valueOf(this.registry.key().location()));
        }
        return type;
    }

    private Function<String, T> convertToElement() {
        return elementLoc -> this.registry.get(ResourceLocation.parse((String)elementLoc)).map(Holder.Reference::value).orElseThrow(() -> new IllegalArgumentException(elementLoc + " could not be found in registry " + String.valueOf(this.registry.key().location())));
    }

    private Function<String, TagKey<T>> replaceHashAndConvertToTag() {
        return elementLoc -> TagKey.create((ResourceKey)this.registry.key(), (ResourceLocation)ResourceLocation.parse((String)elementLoc.replace("#", "")));
    }
}

