/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.mixin;

import com.daqem.arc.api.IArcAbstractArrow;
import com.daqem.arc.api.player.ArcServerPlayer;
import com.daqem.arc.event.triggers.ItemEvents;
import com.daqem.arc.event.triggers.PlayerEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Projectile.class})
public abstract class MixinProjectile
extends Entity {
    public MixinProjectile(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="HEAD")}, method={"shootFromRotation(Lnet/minecraft/world/entity/Entity;FFFFF)V"})
    private void shootFromRotation(Entity entity, float f, float g, float h, float i, float j, CallbackInfo ci) {
        if (entity instanceof ArcServerPlayer) {
            ArcServerPlayer player = (ArcServerPlayer)entity;
            Projectile projectile = (Projectile)this;
            if (projectile instanceof ThrowableItemProjectile) {
                ThrowableItemProjectile throwableItemProjectile = (ThrowableItemProjectile)projectile;
                ItemEvents.onThrowItem(player, throwableItemProjectile);
            } else {
                projectile = (Projectile)this;
                if (projectile instanceof IArcAbstractArrow) {
                    IArcAbstractArrow abstractArrow = (IArcAbstractArrow)projectile;
                    PlayerEvents.onShootProjectile(player, abstractArrow);
                }
            }
        }
    }
}

