/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.networking;

import com.daqem.arc.api.action.holder.ActionHolderManager;
import com.daqem.arc.api.action.holder.IActionHolder;
import com.daqem.arc.networking.ArcNetworking;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ClientboundSyncPlayerActionHoldersPacket
implements CustomPacketPayload {
    private final List<IActionHolder> actionHolders;
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundSyncPlayerActionHoldersPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ClientboundSyncPlayerActionHoldersPacket>(){

        @NotNull
        public ClientboundSyncPlayerActionHoldersPacket decode(RegistryFriendlyByteBuf buf) {
            return new ClientboundSyncPlayerActionHoldersPacket(buf);
        }

        public void encode(RegistryFriendlyByteBuf buf, ClientboundSyncPlayerActionHoldersPacket packet) {
            buf.writeInt(packet.actionHolders.size());
            for (IActionHolder actionHolder : packet.actionHolders) {
                buf.writeResourceLocation(actionHolder.getLocation());
            }
        }
    };

    public ClientboundSyncPlayerActionHoldersPacket(List<IActionHolder> actionHolders) {
        this.actionHolders = actionHolders;
    }

    public ClientboundSyncPlayerActionHoldersPacket(RegistryFriendlyByteBuf friendlyByteBuf) {
        ArrayList<ResourceLocation> actionHolderLocations = new ArrayList<ResourceLocation>();
        int size = friendlyByteBuf.readInt();
        for (int i = 0; i < size; ++i) {
            actionHolderLocations.add(friendlyByteBuf.readResourceLocation());
        }
        this.actionHolders = ActionHolderManager.getInstance().getActionHolders(actionHolderLocations);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ArcNetworking.CLIENTBOUND_SYNC_PLAYER_ACTION_HOLDERS;
    }

    public List<IActionHolder> getActionHolders() {
        return this.actionHolders;
    }
}

