/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.api.action.holder.serializer;

import com.daqem.arc.api.action.IAction;
import com.daqem.arc.api.action.holder.IActionHolder;
import com.daqem.arc.api.action.holder.type.IActionHolderType;
import com.daqem.arc.api.action.serializer.IActionSerializer;
import com.daqem.arc.data.serializer.ArcSerializer;
import com.daqem.arc.registry.ArcRegistry;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public interface IActionHolderSerializer<T extends IActionHolder>
extends ArcSerializer {
    public T fromJson(JsonObject var1, ResourceLocation var2);

    public T fromNetwork(RegistryFriendlyByteBuf var1, ResourceLocation var2);

    public static IActionHolder fromNetwork(RegistryFriendlyByteBuf friendlyByteBuf) {
        ResourceLocation resourceLocation = friendlyByteBuf.readResourceLocation();
        ResourceLocation resourceLocation2 = friendlyByteBuf.readResourceLocation();
        return ((IActionHolderType)ArcRegistry.ACTION_HOLDER.getOptional(resourceLocation).orElseThrow(() -> new IllegalArgumentException("Unknown action holder serializer " + String.valueOf(resourceLocation)))).getSerializer().fromNetwork(resourceLocation2, friendlyByteBuf);
    }

    public static <T extends IActionHolder> void toNetwork(T actionHolder, RegistryFriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeResourceLocation(ArcRegistry.ACTION_HOLDER.getKey(actionHolder.getType()));
        friendlyByteBuf.writeResourceLocation(actionHolder.getLocation());
        actionHolder.getSerializer().toNetwork(friendlyByteBuf, actionHolder);
    }

    default public T fromJson(ResourceLocation location, JsonObject jsonObject) {
        return this.fromJson(jsonObject, location);
    }

    default public T fromNetwork(ResourceLocation location, RegistryFriendlyByteBuf friendlyByteBuf) {
        T actionHolder = this.fromNetwork(friendlyByteBuf, location);
        List actions = friendlyByteBuf.readList(friendlyByteBuf1 -> IActionSerializer.fromNetwork((RegistryFriendlyByteBuf)friendlyByteBuf1));
        actionHolder.addActions(actions);
        return actionHolder;
    }

    default public void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, T type) {
        List<IAction> actions = type.getActions();
        friendlyByteBuf.writeCollection(actions, (buf, action) -> IActionSerializer.toNetwork(action, (RegistryFriendlyByteBuf)buf));
    }
}

