/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.api.action.serializer;

import com.daqem.arc.api.action.IAction;
import com.daqem.arc.api.action.holder.type.IActionHolderType;
import com.daqem.arc.api.action.type.IActionType;
import com.daqem.arc.api.condition.ICondition;
import com.daqem.arc.api.condition.serializer.IConditionSerializer;
import com.daqem.arc.api.reward.IReward;
import com.daqem.arc.api.reward.serializer.IRewardSerializer;
import com.daqem.arc.data.serializer.ArcSerializer;
import com.daqem.arc.registry.ArcRegistry;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public interface IActionSerializer<T extends IAction>
extends ArcSerializer {
    public T fromJson(ResourceLocation var1, JsonObject var2, ResourceLocation var3, IActionHolderType<?> var4, boolean var5, List<IReward> var6, List<ICondition> var7);

    public T fromNetwork(ResourceLocation var1, RegistryFriendlyByteBuf var2, ResourceLocation var3, IActionHolderType<?> var4, boolean var5, List<IReward> var6, List<ICondition> var7);

    public static IAction fromNetwork(RegistryFriendlyByteBuf friendlyByteBuf) {
        ResourceLocation resourceLocation = friendlyByteBuf.readResourceLocation();
        ResourceLocation resourceLocation2 = friendlyByteBuf.readResourceLocation();
        return ((IActionType)ArcRegistry.ACTION.getOptional(resourceLocation).orElseThrow(() -> new IllegalArgumentException("Unknown action serializer " + String.valueOf(resourceLocation)))).getSerializer().fromNetwork(resourceLocation2, friendlyByteBuf);
    }

    public static <T extends IAction> void toNetwork(T action, RegistryFriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeResourceLocation(ArcRegistry.ACTION.getKey(action.getType()));
        friendlyByteBuf.writeResourceLocation(action.getLocation());
        action.getSerializer().toNetwork(friendlyByteBuf, action);
    }

    default public T fromJson(ResourceLocation location, JsonObject jsonObject) {
        ArrayList<IReward> rewards = new ArrayList<IReward>();
        if (jsonObject.has("rewards")) {
            jsonObject.getAsJsonArray("rewards").forEach(jsonElement -> {
                ResourceLocation rewardTypeLocation = this.getResourceLocation(jsonElement.getAsJsonObject(), "type");
                ArcRegistry.REWARD.getOptional(rewardTypeLocation).ifPresent(rewardType -> rewards.add((IReward)rewardType.getSerializer().fromJson(location, jsonElement.getAsJsonObject())));
            });
        }
        ArrayList<ICondition> conditions = new ArrayList<ICondition>();
        if (jsonObject.has("conditions")) {
            jsonObject.getAsJsonArray("conditions").forEach(jsonElement -> {
                ResourceLocation conditionTypeLocation = this.getResourceLocation(jsonElement.getAsJsonObject(), "type");
                ArcRegistry.CONDITION.getOptional(conditionTypeLocation).ifPresent(conditionType -> conditions.add((ICondition)conditionType.getSerializer().fromJson(location, jsonElement.getAsJsonObject())));
            });
        }
        JsonObject holderObject = GsonHelper.getAsJsonObject((JsonObject)jsonObject, (String)"holder");
        return this.fromJson(location, jsonObject, this.getResourceLocation(holderObject, "id"), this.getHolderType(holderObject, "type"), false, rewards, conditions);
    }

    default public T fromNetwork(ResourceLocation location, RegistryFriendlyByteBuf friendlyByteBuf) {
        return this.fromNetwork(location, friendlyByteBuf, friendlyByteBuf.readResourceLocation(), ArcRegistry.ACTION_HOLDER.getOptional(friendlyByteBuf.readResourceLocation()).orElse(null), friendlyByteBuf.readBoolean(), friendlyByteBuf.readList(object -> IRewardSerializer.fromNetwork((RegistryFriendlyByteBuf)object)), friendlyByteBuf.readList(object -> IConditionSerializer.fromNetwork((RegistryFriendlyByteBuf)object)));
    }

    default public void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, T type) {
        friendlyByteBuf.writeResourceLocation(type.getActionHolderLocation());
        friendlyByteBuf.writeResourceLocation(type.getActionHolderType().getLocation());
        friendlyByteBuf.writeBoolean(type.shouldPerformOnClient());
        friendlyByteBuf.writeCollection(type.getRewards(), (friendlyByteBuf1, reward) -> IRewardSerializer.toNetwork(reward, (RegistryFriendlyByteBuf)friendlyByteBuf1, type.getLocation()));
        friendlyByteBuf.writeCollection(type.getConditions(), (friendlyByteBuf1, condition) -> IConditionSerializer.toNetwork(condition, (RegistryFriendlyByteBuf)friendlyByteBuf1, type.getLocation()));
    }
}

