/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.api.condition.type;

import com.daqem.arc.Arc;
import com.daqem.arc.api.condition.ICondition;
import com.daqem.arc.api.condition.serializer.IConditionSerializer;
import com.daqem.arc.api.condition.type.IConditionType;
import com.daqem.arc.data.condition.NotCondition;
import com.daqem.arc.data.condition.OrCondition;
import com.daqem.arc.data.condition.block.BlockCondition;
import com.daqem.arc.data.condition.block.BlocksCondition;
import com.daqem.arc.data.condition.block.NotInBlockPosCacheCondition;
import com.daqem.arc.data.condition.block.crop.CropAgeCondition;
import com.daqem.arc.data.condition.block.crop.CropFullyGrownCondition;
import com.daqem.arc.data.condition.block.ore.IsOreCondition;
import com.daqem.arc.data.condition.block.properties.BlockHardnessCondition;
import com.daqem.arc.data.condition.effect.EffectCategoryCondition;
import com.daqem.arc.data.condition.effect.EffectCondition;
import com.daqem.arc.data.condition.entity.DamageSourceCondition;
import com.daqem.arc.data.condition.entity.EntityInBlockCondition;
import com.daqem.arc.data.condition.entity.EntityTypeCondition;
import com.daqem.arc.data.condition.entity.EntityTypesCondition;
import com.daqem.arc.data.condition.entity.ReadyForShearingCondition;
import com.daqem.arc.data.condition.experience.ExpDropCondition;
import com.daqem.arc.data.condition.experience.ExpLevelCondition;
import com.daqem.arc.data.condition.item.ItemCondition;
import com.daqem.arc.data.condition.item.ItemEquippedCondition;
import com.daqem.arc.data.condition.item.ItemInHandCondition;
import com.daqem.arc.data.condition.item.ItemInInventoryCondition;
import com.daqem.arc.data.condition.item.ItemsCondition;
import com.daqem.arc.data.condition.movement.DistanceCondition;
import com.daqem.arc.data.condition.recipe.IsBlastingRecipeCondition;
import com.daqem.arc.data.condition.recipe.IsSmokingRecipeCondition;
import com.daqem.arc.data.condition.scoreboard.ScoreboardCondition;
import com.daqem.arc.data.condition.team.TeamCondition;
import com.daqem.arc.data.condition.world.DimensionCondition;
import com.daqem.arc.event.events.RegistryEvent;
import com.daqem.arc.registry.ArcRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;

public interface ConditionType<T extends ICondition>
extends IConditionType<T> {
    public static final ConditionType<OrCondition> OR = ConditionType.register(Arc.getId("or"), new OrCondition.Serializer());
    public static final ConditionType<NotCondition> NOT = ConditionType.register(Arc.getId("not"), new NotCondition.Serializer());
    public static final ConditionType<CropFullyGrownCondition> CROP_FULLY_GROWN = ConditionType.register(Arc.getId("crop_fully_grown"), new CropFullyGrownCondition.Serializer());
    public static final ConditionType<CropAgeCondition> CROP_AGE = ConditionType.register(Arc.getId("crop_age"), new CropAgeCondition.Serializer());
    public static final ConditionType<BlockCondition> BLOCK = ConditionType.register(Arc.getId("block"), new BlockCondition.Serializer());
    public static final ConditionType<BlocksCondition> BLOCKS = ConditionType.register(Arc.getId("blocks"), new BlocksCondition.Serializer());
    public static final ConditionType<DistanceCondition> DISTANCE = ConditionType.register(Arc.getId("distance"), new DistanceCondition.Serializer());
    public static final ConditionType<EntityTypeCondition> ENTITY_TYPE = ConditionType.register(Arc.getId("entity_type"), new EntityTypeCondition.Serializer());
    public static final ConditionType<EntityTypesCondition> ENTITY_TYPES = ConditionType.register(Arc.getId("entity_types"), new EntityTypesCondition.Serializer());
    public static final ConditionType<DimensionCondition> DIMENSION = ConditionType.register(Arc.getId("dimension"), new DimensionCondition.Serializer());
    public static final ConditionType<ScoreboardCondition> SCOREBOARD = ConditionType.register(Arc.getId("scoreboard"), new ScoreboardCondition.Serializer());
    public static final ConditionType<TeamCondition> TEAM = ConditionType.register(Arc.getId("team"), new TeamCondition.Serializer());
    public static final ConditionType<ItemInHandCondition> ITEM_IN_HAND = ConditionType.register(Arc.getId("item_in_hand"), new ItemInHandCondition.Serializer());
    public static final ConditionType<ItemInInventoryCondition> ITEM_IN_INVENTORY = ConditionType.register(Arc.getId("item_in_inventory"), new ItemInInventoryCondition.Serializer());
    public static final ConditionType<ItemEquippedCondition> ITEM_EQUIPPED = ConditionType.register(Arc.getId("item_equipped"), new ItemEquippedCondition.Serializer());
    public static final ConditionType<ItemCondition> ITEM = ConditionType.register(Arc.getId("item"), new ItemCondition.Serializer());
    public static final ConditionType<ItemsCondition> ITEMS = ConditionType.register(Arc.getId("items"), new ItemsCondition.Serializer());
    public static final ConditionType<ExpDropCondition> EXP_DROP = ConditionType.register(Arc.getId("exp_drop"), new ExpDropCondition.Serializer());
    public static final ConditionType<ExpLevelCondition> EXP_LEVEL = ConditionType.register(Arc.getId("exp_level"), new ExpLevelCondition.Serializer());
    public static final ConditionType<ReadyForShearingCondition> READY_FOR_SHEARING = ConditionType.register(Arc.getId("ready_for_shearing"), new ReadyForShearingCondition.Serializer());
    public static final ConditionType<IsBlastingRecipeCondition> IS_BLASTING_RECIPE = ConditionType.register(Arc.getId("is_blasting_recipe"), new IsBlastingRecipeCondition.Serializer());
    public static final ConditionType<IsSmokingRecipeCondition> IS_SMOKING_RECIPE = ConditionType.register(Arc.getId("is_smoking_recipe"), new IsSmokingRecipeCondition.Serializer());
    public static final ConditionType<IsOreCondition> IS_ORE = ConditionType.register(Arc.getId("is_ore"), new IsOreCondition.Serializer());
    public static final ConditionType<EffectCategoryCondition> EFFECT_CATEGORY = ConditionType.register(Arc.getId("effect_category"), new EffectCategoryCondition.Serializer());
    public static final ConditionType<EffectCondition> EFFECT = ConditionType.register(Arc.getId("effect"), new EffectCondition.Serializer());
    public static final ConditionType<BlockHardnessCondition> BLOCK_HARDNESS = ConditionType.register(Arc.getId("block_hardness"), new BlockHardnessCondition.Serializer());
    public static final IConditionType<EntityInBlockCondition> ENTITY_IN_BLOCK = ConditionType.register(Arc.getId("entity_in_block"), new EntityInBlockCondition.Serializer());
    public static final IConditionType<DamageSourceCondition> DAMAGE_SOURCE = ConditionType.register(Arc.getId("damage_source"), new DamageSourceCondition.Serializer());
    public static final IConditionType<NotInBlockPosCacheCondition> NOT_IN_BLOCK_POS_CACHE = ConditionType.register(Arc.getId("not_in_block_pos_cache"), new NotInBlockPosCacheCondition.Serializer());

    public static <T extends ICondition> ConditionType<T> register(final ResourceLocation location, final IConditionSerializer<T> serializer) {
        return (ConditionType)Registry.register(ArcRegistry.CONDITION, (ResourceLocation)location, (Object)new ConditionType<T>(){

            @Override
            public ResourceLocation getLocation() {
                return location;
            }

            @Override
            public IConditionSerializer<T> getSerializer() {
                return serializer;
            }

            public String toString() {
                return location.toString();
            }
        });
    }

    public static void init() {
        ((RegistryEvent.RegisterConditionType)RegistryEvent.REGISTER_CONDITION_TYPE.invoker()).registerConditionType();
    }
}

