/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.command;

import com.daqem.arc.api.action.IAction;
import com.daqem.arc.api.action.holder.ActionHolderManager;
import com.daqem.arc.api.action.holder.IActionHolder;
import com.daqem.arc.api.player.ArcServerPlayer;
import com.daqem.arc.command.argument.ActionArgument;
import com.daqem.arc.networking.ClientboundActionHoldersScreenPacket;
import com.daqem.arc.networking.ClientboundActionScreenPacket;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;

public class ArcCommand {
    public static void registerCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"arc").requires(source -> source.hasPermission(2))).then(((LiteralArgumentBuilder)Commands.literal((String)"screen").then(((LiteralArgumentBuilder)Commands.literal((String)"action").then(Commands.argument((String)"action", (ArgumentType)ActionArgument.action()).executes(context -> {
            IAction action = ActionArgument.getAction(context, "action");
            return ArcCommand.openActionScreen((CommandSourceStack)context.getSource(), action);
        }))).executes(context -> {
            List<IAction> actions = ActionHolderManager.getInstance().getActions();
            if (actions.isEmpty()) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"No actions found"));
                return 1;
            }
            return ArcCommand.openActionScreen((CommandSourceStack)context.getSource(), actions.get(0));
        }))).then(Commands.literal((String)"holders").executes(context -> {
            ServerPlayer patt0$temp = ((CommandSourceStack)context.getSource()).getPlayer();
            if (patt0$temp instanceof ArcServerPlayer) {
                ArcServerPlayer arcServerPlayer = (ArcServerPlayer)patt0$temp;
                List<IActionHolder> actionHolders = arcServerPlayer.arc$getActionHolders();
                if (actionHolders.isEmpty()) {
                    ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"No action holders found"));
                    return 1;
                }
                return ArcCommand.openActionHoldersScreen((CommandSourceStack)context.getSource(), actionHolders);
            }
            return 0;
        }))));
    }

    private static int openActionScreen(CommandSourceStack source, IAction action) {
        if (action == null) {
            source.sendFailure((Component)Component.literal((String)"Unknown action"));
            return 0;
        }
        if (source.getPlayer() != null) {
            NetworkManager.sendToPlayer((ServerPlayer)source.getPlayer(), (CustomPacketPayload)new ClientboundActionScreenPacket(action));
        }
        return 1;
    }

    private static int openActionHoldersScreen(CommandSourceStack source, List<IActionHolder> actionHolders) {
        if (source.getPlayer() != null) {
            NetworkManager.sendToPlayer((ServerPlayer)source.getPlayer(), (CustomPacketPayload)new ClientboundActionHoldersScreenPacket(actionHolders));
        }
        return 1;
    }
}

