/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.condition;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.condition.AbstractCondition;
import com.daqem.arc.api.condition.ICondition;
import com.daqem.arc.api.condition.serializer.IConditionSerializer;
import com.daqem.arc.api.condition.type.ConditionType;
import com.daqem.arc.api.condition.type.IConditionType;
import com.daqem.arc.registry.ArcRegistry;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class NotCondition
extends AbstractCondition {
    private final List<ICondition> conditions = new ArrayList<ICondition>();

    public NotCondition(boolean inverted, List<ICondition> conditions) {
        super(inverted);
        this.conditions.addAll(conditions);
    }

    @Override
    public boolean isMet(ActionData actionData) {
        return this.conditions.stream().noneMatch(condition -> condition.isMet(actionData));
    }

    public IConditionType<?> getType() {
        return ConditionType.NOT;
    }

    public List<ICondition> getConditions() {
        return this.conditions;
    }

    public static class Serializer
    implements IConditionSerializer<NotCondition> {
        @Override
        public NotCondition fromJson(ResourceLocation location, JsonObject jsonObject, boolean inverted) {
            ArrayList<ICondition> tempConditions = new ArrayList<ICondition>();
            JsonArray jsonArray = GsonHelper.getAsJsonArray((JsonObject)jsonObject, (String)"conditions");
            jsonArray.forEach(jsonElement -> {
                JsonObject conditionObject = jsonElement.getAsJsonObject();
                ResourceLocation type = this.getResourceLocation(conditionObject, "type");
                IConditionSerializer conditionSerializer = ArcRegistry.CONDITION.getOptional(type).map(IConditionType::getSerializer).orElseThrow(() -> new JsonParseException("Unknown condition type: " + String.valueOf(type)));
                if (conditionSerializer == null) {
                    throw new JsonParseException("Unknown condition type: " + String.valueOf(type));
                }
                tempConditions.add((ICondition)conditionSerializer.fromJson(location, conditionObject));
            });
            return new NotCondition(inverted, tempConditions);
        }

        @Override
        public NotCondition fromNetwork(ResourceLocation location, RegistryFriendlyByteBuf friendlyByteBuf, boolean inverted) {
            ArrayList<ICondition> tempConditions = new ArrayList<ICondition>();
            int size = friendlyByteBuf.readVarInt();
            for (int i = 0; i < size; ++i) {
                ICondition condition = IConditionSerializer.fromNetwork(friendlyByteBuf);
                if (condition == null) continue;
                tempConditions.add(condition);
            }
            return new NotCondition(inverted, tempConditions);
        }

        @Override
        public void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, NotCondition type) {
            IConditionSerializer.super.toNetwork(friendlyByteBuf, type);
            friendlyByteBuf.writeVarInt(type.conditions.size());
            type.conditions.forEach(condition -> IConditionSerializer.toNetwork(condition, friendlyByteBuf, condition.getType().getLocation()));
        }
    }
}

