/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.networking;

import com.daqem.arc.Arc;
import com.daqem.arc.networking.ClientboundActionHoldersScreenPacket;
import com.daqem.arc.networking.ClientboundActionScreenPacket;
import com.daqem.arc.networking.ClientboundSyncPlayerActionHoldersPacket;
import com.daqem.arc.networking.ClientboundUpdateActionHoldersPacket;
import com.daqem.arc.networking.ClientboundUpdateActionsPacket;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public interface ArcNetworking {
    public static final CustomPacketPayload.Type<ClientboundUpdateActionsPacket> CLIENTBOUND_UPDATE_ACTIONS = new CustomPacketPayload.Type(Arc.getId("clientbound_update_actions"));
    public static final CustomPacketPayload.Type<ClientboundUpdateActionHoldersPacket> CLIENTBOUND_UPDATE_ACTION_HOLDERS = new CustomPacketPayload.Type(Arc.getId("clientbound_update_action_holders"));
    public static final CustomPacketPayload.Type<ClientboundActionScreenPacket> CLIENTBOUND_ACTION_SCREEN = new CustomPacketPayload.Type(Arc.getId("clientbound_action_screen"));
    public static final CustomPacketPayload.Type<ClientboundSyncPlayerActionHoldersPacket> CLIENTBOUND_SYNC_PLAYER_ACTION_HOLDERS = new CustomPacketPayload.Type(Arc.getId("clientbound_sync_player_action_holders"));
    public static final CustomPacketPayload.Type<ClientboundActionHoldersScreenPacket> CLIENTBOUND_ACTION_HOLDERS_SCREEN_PACKET = new CustomPacketPayload.Type(Arc.getId("clientbound_action_holders_screen_packet"));

    public static void initClient() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, CLIENTBOUND_UPDATE_ACTIONS, ClientboundUpdateActionsPacket.STREAM_CODEC, ClientboundUpdateActionsPacket::handleClientSide);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, CLIENTBOUND_UPDATE_ACTION_HOLDERS, ClientboundUpdateActionHoldersPacket.STREAM_CODEC, ClientboundUpdateActionHoldersPacket::handleClientSide);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, CLIENTBOUND_ACTION_SCREEN, ClientboundActionScreenPacket.STREAM_CODEC, ClientboundActionScreenPacket::handleClientSide);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, CLIENTBOUND_SYNC_PLAYER_ACTION_HOLDERS, ClientboundSyncPlayerActionHoldersPacket.STREAM_CODEC, ClientboundSyncPlayerActionHoldersPacket::handleClientSide);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, CLIENTBOUND_ACTION_HOLDERS_SCREEN_PACKET, ClientboundActionHoldersScreenPacket.STREAM_CODEC, ClientboundActionHoldersScreenPacket::handleClientSide);
    }

    public static void initServer() {
        NetworkManager.registerS2CPayloadType(CLIENTBOUND_UPDATE_ACTIONS, ClientboundUpdateActionsPacket.STREAM_CODEC);
        NetworkManager.registerS2CPayloadType(CLIENTBOUND_UPDATE_ACTION_HOLDERS, ClientboundUpdateActionHoldersPacket.STREAM_CODEC);
        NetworkManager.registerS2CPayloadType(CLIENTBOUND_ACTION_SCREEN, ClientboundActionScreenPacket.STREAM_CODEC);
        NetworkManager.registerS2CPayloadType(CLIENTBOUND_SYNC_PLAYER_ACTION_HOLDERS, ClientboundSyncPlayerActionHoldersPacket.STREAM_CODEC);
        NetworkManager.registerS2CPayloadType(CLIENTBOUND_ACTION_HOLDERS_SCREEN_PACKET, ClientboundActionHoldersScreenPacket.STREAM_CODEC);
    }

    public static void init() {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> ArcNetworking::initClient);
        EnvExecutor.runInEnv((Env)Env.SERVER, () -> ArcNetworking::initServer);
    }
}

