/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.api.action;

import com.daqem.arc.Arc;
import com.daqem.arc.api.action.IAction;
import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.holder.IActionHolder;
import com.daqem.arc.api.action.holder.type.IActionHolderType;
import com.daqem.arc.api.action.result.ActionResult;
import com.daqem.arc.api.action.serializer.IActionSerializer;
import com.daqem.arc.api.condition.ICondition;
import com.daqem.arc.api.reward.IReward;
import com.daqem.arc.event.events.ActionEvent;
import dev.architectury.event.EventResult;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public abstract class AbstractAction
implements IAction {
    private final class_2960 location;
    private final class_2960 actionHolderLocation;
    private final IActionHolderType<?> actionHolderType;
    private final boolean performOnClient;
    private final List<IReward> rewards;
    private final List<ICondition> conditions;

    public AbstractAction(class_2960 location, class_2960 actionHolderLocation, IActionHolderType<?> actionHolderType, boolean performOnClient, List<IReward> rewards, List<ICondition> conditions) {
        this.location = location;
        this.actionHolderLocation = actionHolderLocation;
        this.actionHolderType = actionHolderType;
        this.performOnClient = performOnClient;
        this.rewards = rewards;
        this.conditions = conditions;
    }

    @Override
    public class_2960 getLocation() {
        return this.location;
    }

    @Override
    public IActionHolderType<?> getActionHolderType() {
        return this.actionHolderType;
    }

    @Override
    public class_2960 getActionHolderLocation() {
        return this.actionHolderLocation;
    }

    @Override
    public boolean shouldPerformOnClient() {
        return this.performOnClient;
    }

    @Override
    public IActionSerializer<?> getSerializer() {
        return this.getType().getSerializer();
    }

    @Override
    public class_2561 getName() {
        return Arc.translatable("action." + this.getType().getLocation().method_12832());
    }

    @Override
    public class_2561 getDescription() {
        return Arc.translatable("action.description." + this.getType().getLocation().method_12832());
    }

    @Override
    public class_2561 getShortDescription() {
        return Arc.translatable("action.short_description." + this.getType().getLocation().method_12832());
    }

    @Override
    public List<IReward> getRewards() {
        return this.rewards;
    }

    @Override
    public List<ICondition> getConditions() {
        return this.conditions;
    }

    @Override
    public ActionResult perform(ActionData actionData) {
        IActionHolder sourceActionHolder = actionData.getPlayer().arc$getActionHolders().stream().filter(actionHolder -> actionHolder.getType() == this.getActionHolderType() && actionHolder.getLocation().equals((Object)this.getActionHolderLocation())).findFirst().orElseThrow(() -> new IllegalStateException("Action holder not found for action " + String.valueOf(this.getType().getLocation()) + " and action holder " + String.valueOf(this.getActionHolderLocation())));
        actionData.setSourceActionHolder(sourceActionHolder);
        ActionResult result = new ActionResult();
        if (actionData.getPlayer().arc$getLevel().method_8608() && !this.performOnClient) {
            return result;
        }
        EventResult beforeConditionsEventResult = ((ActionEvent.BeforeConditions)ActionEvent.BEFORE_CONDITIONS.invoker()).registerBeforeConditions(actionData);
        if (beforeConditionsEventResult == EventResult.interrupt((Boolean)true)) {
            return result;
        }
        if (!actionData.getSourceActionHolder().passedHolderCondition(actionData)) {
            return result;
        }
        if (this.metConditions(actionData)) {
            EventResult beforeRewardsEventResult = ((ActionEvent.BeforeRewards)ActionEvent.BEFORE_REWARDS.invoker()).registerBeforeRewards(actionData);
            if (beforeRewardsEventResult == EventResult.interrupt((Boolean)true)) {
                return result;
            }
            if (Arc.isDebugEnvironment()) {
                Arc.LOGGER.info("Action {} passed conditions for action holder {}", (Object)this.getType().getLocation(), (Object)this.actionHolderLocation);
            }
            result = this.applyRewards(actionData);
        }
        return result;
    }

    @Override
    public boolean metConditions(ActionData actionData) {
        return this.conditions.stream().allMatch(condition -> condition.isMet(actionData));
    }

    @Override
    public ActionResult applyRewards(ActionData actionData) {
        return this.rewards.stream().sorted((reward1, reward2) -> Integer.compare(reward2.getPriority(), reward1.getPriority())).map(reward -> AbstractAction.applyReward(actionData, reward)).reduce(new ActionResult(), ActionResult::merge);
    }

    private static ActionResult applyReward(ActionData actionData, IReward reward) {
        if (reward.passedChance(actionData)) {
            return reward.apply(actionData);
        }
        return new ActionResult();
    }

    public boolean equals(Object obj) {
        IAction action;
        return obj instanceof IAction && (action = (IAction)obj).getLocation().equals((Object)this.getLocation());
    }
}

