/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.api.action.serializer;

import com.daqem.arc.api.action.IAction;
import com.daqem.arc.api.action.holder.type.IActionHolderType;
import com.daqem.arc.api.action.type.IActionType;
import com.daqem.arc.api.condition.ICondition;
import com.daqem.arc.api.condition.serializer.IConditionSerializer;
import com.daqem.arc.api.reward.IReward;
import com.daqem.arc.api.reward.serializer.IRewardSerializer;
import com.daqem.arc.data.serializer.ArcSerializer;
import com.daqem.arc.registry.ArcRegistry;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_9129;

public interface IActionSerializer<T extends IAction>
extends ArcSerializer {
    public T fromJson(class_2960 var1, JsonObject var2, class_2960 var3, IActionHolderType<?> var4, boolean var5, List<IReward> var6, List<ICondition> var7);

    public T fromNetwork(class_2960 var1, class_9129 var2, class_2960 var3, IActionHolderType<?> var4, boolean var5, List<IReward> var6, List<ICondition> var7);

    public static IAction fromNetwork(class_9129 friendlyByteBuf) {
        class_2960 resourceLocation = friendlyByteBuf.method_10810();
        class_2960 resourceLocation2 = friendlyByteBuf.method_10810();
        return ((IActionType)ArcRegistry.ACTION.method_17966(resourceLocation).orElseThrow(() -> new IllegalArgumentException("Unknown action serializer " + String.valueOf(resourceLocation)))).getSerializer().fromNetwork(resourceLocation2, friendlyByteBuf);
    }

    public static <T extends IAction> void toNetwork(T action, class_9129 friendlyByteBuf) {
        friendlyByteBuf.method_10812(ArcRegistry.ACTION.method_10221(action.getType()));
        friendlyByteBuf.method_10812(action.getLocation());
        action.getSerializer().toNetwork(friendlyByteBuf, action);
    }

    default public T fromJson(class_2960 location, JsonObject jsonObject) {
        ArrayList<IReward> rewards = new ArrayList<IReward>();
        if (jsonObject.has("rewards")) {
            jsonObject.getAsJsonArray("rewards").forEach(jsonElement -> {
                class_2960 rewardTypeLocation = this.getResourceLocation(jsonElement.getAsJsonObject(), "type");
                ArcRegistry.REWARD.method_17966(rewardTypeLocation).ifPresent(rewardType -> rewards.add((IReward)rewardType.getSerializer().fromJson(location, jsonElement.getAsJsonObject())));
            });
        }
        ArrayList<ICondition> conditions = new ArrayList<ICondition>();
        if (jsonObject.has("conditions")) {
            jsonObject.getAsJsonArray("conditions").forEach(jsonElement -> {
                class_2960 conditionTypeLocation = this.getResourceLocation(jsonElement.getAsJsonObject(), "type");
                ArcRegistry.CONDITION.method_17966(conditionTypeLocation).ifPresent(conditionType -> conditions.add((ICondition)conditionType.getSerializer().fromJson(location, jsonElement.getAsJsonObject())));
            });
        }
        JsonObject holderObject = class_3518.method_15296((JsonObject)jsonObject, (String)"holder");
        return this.fromJson(location, jsonObject, this.getResourceLocation(holderObject, "id"), this.getHolderType(holderObject, "type"), false, rewards, conditions);
    }

    default public T fromNetwork(class_2960 location, class_9129 friendlyByteBuf) {
        return this.fromNetwork(location, friendlyByteBuf, friendlyByteBuf.method_10810(), ArcRegistry.ACTION_HOLDER.method_17966(friendlyByteBuf.method_10810()).orElse(null), friendlyByteBuf.readBoolean(), friendlyByteBuf.method_34066(object -> IRewardSerializer.fromNetwork((class_9129)object)), friendlyByteBuf.method_34066(object -> IConditionSerializer.fromNetwork((class_9129)object)));
    }

    default public void toNetwork(class_9129 friendlyByteBuf, T type) {
        friendlyByteBuf.method_10812(type.getActionHolderLocation());
        friendlyByteBuf.method_10812(type.getActionHolderType().getLocation());
        friendlyByteBuf.method_52964(type.shouldPerformOnClient());
        friendlyByteBuf.method_34062(type.getRewards(), (friendlyByteBuf1, reward) -> IRewardSerializer.toNetwork(reward, (class_9129)friendlyByteBuf1, type.getLocation()));
        friendlyByteBuf.method_34062(type.getConditions(), (friendlyByteBuf1, condition) -> IConditionSerializer.toNetwork(condition, (class_9129)friendlyByteBuf1, type.getLocation()));
    }
}

