/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.client.gui.action;

import com.daqem.arc.Arc;
import com.daqem.arc.api.action.IAction;
import com.daqem.arc.client.gui.action.components.ActionComponent;
import com.daqem.arc.client.gui.icon.ArcIcons;
import com.daqem.uilib.api.client.gui.background.IBackground;
import com.daqem.uilib.api.client.gui.component.IComponent;
import com.daqem.uilib.api.client.gui.texture.ITexture;
import com.daqem.uilib.client.gui.AbstractScreen;
import com.daqem.uilib.client.gui.background.Backgrounds;
import com.daqem.uilib.client.gui.component.texture.TextureComponent;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class ActionScreen
extends AbstractScreen {
    private static final int KEY_BACK = 263;
    private static final int KEY_FORWARD = 262;
    private final List<IAction> actions;
    private IAction selectedAction;
    public ActionComponent actionComponent;
    public TextureComponent arrowLeftComponent;
    public TextureComponent arrowRightComponent;

    public ActionScreen(List<IAction> actions, IAction selectedAction) {
        super((class_2561)Arc.translatable("screen.action"));
        this.actions = actions;
        this.selectedAction = selectedAction;
    }

    public void startScreen() {
        this.actionComponent = new ActionComponent(this.getFont(), this.getCurrentIndex(), this.selectedAction);
        this.arrowLeftComponent = new TextureComponent((ITexture)ArcIcons.ARROW_LEFT, 0, 0, 20, 20);
        this.arrowRightComponent = new TextureComponent((ITexture)ArcIcons.ARROW_RIGHT, 0, 0, 20, 20);
        this.setPauseScreen(false);
        this.setBackground((IBackground)Backgrounds.getDefaultBackground((int)this.getWidth(), (int)this.getHeight()));
        this.startComponents();
    }

    public void onResizeScreenRepositionComponents(int width, int height) {
        super.onResizeScreenRepositionComponents(width, height);
        this.positionComponents();
    }

    private void startComponents() {
        this.arrowLeftComponent.setOnClickEvent((clickedObject, screen, mouseX, mouseY, button) -> {
            this.moveToPreviousActionComponent();
            return true;
        });
        this.arrowRightComponent.setOnClickEvent((clickedObject, screen, mouseX, mouseY, button) -> {
            this.moveToNextActionComponent();
            return true;
        });
        this.addComponents(new IComponent[]{this.actionComponent, this.arrowLeftComponent, this.arrowRightComponent});
        this.positionComponents();
    }

    private void positionComponents() {
        this.actionComponent.center();
        this.arrowLeftComponent.setX(this.actionComponent.getX());
        this.arrowLeftComponent.setY(this.actionComponent.getY() + this.actionComponent.getHeight() + 5);
        this.arrowRightComponent.setX(this.actionComponent.getX() + this.actionComponent.getWidth() - this.arrowRightComponent.getWidth());
        this.arrowRightComponent.setY(this.actionComponent.getY() + this.actionComponent.getHeight() + 5);
    }

    private int getCurrentIndex() {
        return this.actions.indexOf(this.selectedAction);
    }

    public void onTickScreen(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 263) {
            this.moveToPreviousActionComponent();
            return true;
        }
        if (keyCode == 262) {
            this.moveToNextActionComponent();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private void moveToActionComponent(ActionComponent actionComponent) {
        actionComponent.center();
        this.removeComponent((IComponent)this.actionComponent);
        this.selectedAction = actionComponent.getAction();
        this.actionComponent = actionComponent;
        this.addComponent((IComponent)this.actionComponent);
        this.actionComponent.startRenderable();
    }

    private ActionComponent getNextActionComponent() {
        int nextIndex = this.getCurrentIndex() + 1;
        if (nextIndex >= this.actions.size()) {
            nextIndex = 0;
        }
        if (nextIndex == this.getCurrentIndex()) {
            return this.actionComponent;
        }
        return new ActionComponent(this.getFont(), nextIndex, this.actions.get(nextIndex));
    }

    private ActionComponent getPreviousActionComponent() {
        int previousIndex = this.getCurrentIndex() - 1;
        if (previousIndex < 0) {
            previousIndex = this.actions.size() - 1;
        }
        if (previousIndex == this.getCurrentIndex()) {
            return this.actionComponent;
        }
        return new ActionComponent(this.getFont(), previousIndex, this.actions.get(previousIndex));
    }

    private void moveToPreviousActionComponent() {
        this.moveToActionComponent(this.getPreviousActionComponent());
    }

    private void moveToNextActionComponent() {
        this.moveToActionComponent(this.getNextActionComponent());
    }
}

