/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.client.gui.action.components;

import com.daqem.arc.Arc;
import com.daqem.arc.api.action.IAction;
import com.daqem.arc.client.gui.action.components.AbstractTabComponent;
import com.daqem.arc.client.gui.action.components.ConditionsTabComponent;
import com.daqem.arc.client.gui.action.components.RewardsTabComponent;
import com.daqem.arc.client.gui.action.components.ScrollComponent;
import com.daqem.arc.client.gui.action.components.ScrollItemComponent;
import com.daqem.arc.client.gui.icon.ArcIcons;
import com.daqem.uilib.api.client.gui.component.IComponent;
import com.daqem.uilib.api.client.gui.text.IText;
import com.daqem.uilib.api.client.gui.texture.ITexture;
import com.daqem.uilib.client.gui.component.IconComponent;
import com.daqem.uilib.client.gui.component.SolidColorComponent;
import com.daqem.uilib.client.gui.component.TextComponent;
import com.daqem.uilib.client.gui.component.texture.TextureComponent;
import com.daqem.uilib.client.gui.text.Text;
import com.daqem.uilib.client.gui.text.TruncatedText;
import com.daqem.uilib.client.gui.text.multiline.MultiLineText;
import com.daqem.uilib.client.gui.texture.Texture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;

public class ActionComponent
extends TextureComponent {
    public static final ITexture BACKGROUND_TEXTURE = new Texture(Arc.getId("textures/gui/action_screen.png"), 0, 0, 326, 166, 362);
    private final class_327 font;
    private final int index;
    private final IAction action;
    private TextComponent titleComponent;
    private TextComponent indexComponent;
    private TextComponent descriptionComponent;
    private SolidColorComponent lineComponent;
    private ConditionsTabComponent conditionsTabComponent;
    private RewardsTabComponent rewardsTabComponent;
    private ScrollComponent scrollComponent;

    public ActionComponent(class_327 font, int index, IAction action) {
        super(BACKGROUND_TEXTURE, 0, 0, 326, 166);
        this.font = font;
        this.index = index;
        this.action = action;
    }

    public void startRenderable() {
        String indexString = String.valueOf(this.index + 1);
        class_2561 class_25612 = this.action.getName();
        int n = 130 - this.font.method_1727(indexString);
        Objects.requireNonNull(this.font);
        this.titleComponent = new TextComponent(7, 13, (IText)new TruncatedText(this.font, class_25612, 0, 0, n, 9));
        this.indexComponent = new TextComponent(140, 13, (IText)new Text(this.font, (class_2561)Arc.literal(indexString), -this.font.method_1727(indexString), 0));
        Objects.requireNonNull(this.font);
        this.descriptionComponent = new TextComponent(7, 18 + 9, (IText)new MultiLineText(this.font, this.action.getDescription(), 0, 0, 132));
        Objects.requireNonNull(this.font);
        this.lineComponent = new SolidColorComponent(7, 13 + 9 + 1, 132, 1, -1);
        this.conditionsTabComponent = new ConditionsTabComponent(156, -22, true, new IconComponent(ArcIcons.CONDITION));
        this.rewardsTabComponent = new RewardsTabComponent(188, -22, false, new IconComponent(ArcIcons.REWARD));
        this.scrollComponent = new ScrollComponent(150, 0, 100, 200, this.getScrollItemComponents(this.conditionsTabComponent));
        if (this.titleComponent.getText() != null) {
            this.titleComponent.getText().setTextColor(0x333333);
            this.titleComponent.getText().setBold(true);
        }
        if (this.indexComponent.getText() != null) {
            this.indexComponent.getText().setTextColor(class_124.field_1080);
        }
        if (this.descriptionComponent.getText() != null) {
            this.descriptionComponent.getText().setTextColor(class_124.field_1063);
        }
        this.addChildren(new IComponent[]{this.conditionsTabComponent, this.rewardsTabComponent, this.titleComponent, this.indexComponent, this.descriptionComponent, this.lineComponent, this.scrollComponent});
        super.startRenderable();
    }

    public void selectTab(AbstractTabComponent tabComponent) {
        this.getTabComponents().forEach(t -> t.setSelected(false));
        tabComponent.setSelected(true);
        this.scrollComponent.setItems(this.getScrollItemComponents(tabComponent));
    }

    public List<AbstractTabComponent> getTabComponents() {
        return Arrays.asList(new AbstractTabComponent[]{this.conditionsTabComponent, this.rewardsTabComponent});
    }

    public List<ScrollItemComponent> getScrollItemComponents(AbstractTabComponent activeTabComponent) {
        if (this.action != null) {
            if (activeTabComponent == this.conditionsTabComponent) {
                return this.action.getConditions().stream().map(c -> new ScrollItemComponent(c.getName(), c.getDescription())).toList();
            }
            if (activeTabComponent == this.rewardsTabComponent) {
                return this.action.getRewards().stream().map(c -> new ScrollItemComponent(c.getName(), c.getDescription())).toList();
            }
        }
        return new ArrayList<ScrollItemComponent>();
    }

    public IAction getAction() {
        return this.action;
    }
}

