/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data;

import com.daqem.arc.Arc;
import com.daqem.arc.api.action.IAction;
import com.daqem.arc.api.action.holder.ActionHolderManager;
import com.daqem.arc.api.action.type.IActionType;
import com.daqem.arc.registry.ArcRegistry;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.jetbrains.annotations.NotNull;

public class ActionManager
extends class_4309 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public ActionManager() {
        super(GSON, "arc");
    }

    protected void apply(@NotNull Map<class_2960, JsonElement> map, @NotNull class_3300 resourceManager, @NotNull class_3695 profilerFiller) {
        ActionHolderManager actionHolderManager = ActionHolderManager.getInstance();
        actionHolderManager.clearAllActions();
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (!Arc.isDebugEnvironment()) {
            map.entrySet().removeIf(entry -> ((class_2960)entry.getKey()).method_12836().equals("debug"));
        }
        for (Map.Entry<class_2960, JsonElement> entry2 : map.entrySet()) {
            class_2960 location = entry2.getKey();
            try {
                IAction action = ActionManager.fromJson(location, class_3518.method_15295((JsonElement)entry2.getValue(), (String)"top element"));
                actions.add(action);
            }
            catch (JsonParseException | IllegalArgumentException runtimeException) {
                Arc.LOGGER.error("Parsing error loading action {}", (Object)location, (Object)runtimeException);
            }
        }
        actionHolderManager.registerActions(actions);
        Arc.LOGGER.info("Loaded {} actions", (Object)actions.size());
    }

    public static IAction fromJson(class_2960 location, JsonObject jsonObject) {
        String type = class_3518.method_15265((JsonObject)jsonObject, (String)"type");
        return ((IActionType)ArcRegistry.ACTION.method_17966(class_2960.method_60654((String)type)).orElseThrow(() -> new JsonSyntaxException("Invalid or unsupported action type '" + type + "'"))).getSerializer().fromJson(location, jsonObject);
    }
}

