/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.condition;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.condition.AbstractCondition;
import com.daqem.arc.api.condition.ICondition;
import com.daqem.arc.api.condition.serializer.IConditionSerializer;
import com.daqem.arc.api.condition.type.ConditionType;
import com.daqem.arc.api.condition.type.IConditionType;
import com.daqem.arc.registry.ArcRegistry;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_9129;

public class OrCondition
extends AbstractCondition {
    private final List<ICondition> conditions = new ArrayList<ICondition>();

    public OrCondition(boolean inverted, List<ICondition> conditions) {
        super(inverted);
        this.conditions.addAll(conditions);
    }

    @Override
    public boolean isMet(ActionData actionData) {
        return this.conditions.stream().anyMatch(condition -> condition.isMet(actionData));
    }

    public IConditionType<?> getType() {
        return ConditionType.OR;
    }

    public static class Serializer
    implements IConditionSerializer<OrCondition> {
        @Override
        public OrCondition fromJson(class_2960 location, JsonObject jsonObject, boolean inverted) {
            ArrayList<ICondition> tempConditions = new ArrayList<ICondition>();
            JsonArray jsonArray = class_3518.method_15261((JsonObject)jsonObject, (String)"conditions");
            jsonArray.forEach(jsonElement -> {
                JsonObject conditionObject = jsonElement.getAsJsonObject();
                class_2960 type = this.getResourceLocation(conditionObject, "type");
                IConditionSerializer conditionSerializer = ArcRegistry.CONDITION.method_17966(type).map(IConditionType::getSerializer).orElseThrow(() -> new JsonParseException("Unknown condition type: " + String.valueOf(type)));
                if (conditionSerializer == null) {
                    throw new JsonParseException("Unknown condition type: " + String.valueOf(type));
                }
                tempConditions.add((ICondition)conditionSerializer.fromJson(location, conditionObject));
            });
            return new OrCondition(inverted, tempConditions);
        }

        @Override
        public OrCondition fromNetwork(class_2960 location, class_9129 friendlyByteBuf, boolean inverted) {
            ArrayList<ICondition> tempConditions = new ArrayList<ICondition>();
            int size = friendlyByteBuf.method_10816();
            for (int i = 0; i < size; ++i) {
                ICondition condition = IConditionSerializer.fromNetwork(friendlyByteBuf);
                if (condition == null) continue;
                tempConditions.add(condition);
            }
            return new OrCondition(inverted, tempConditions);
        }

        @Override
        public void toNetwork(class_9129 friendlyByteBuf, OrCondition type) {
            IConditionSerializer.super.toNetwork(friendlyByteBuf, type);
            friendlyByteBuf.method_10804(type.conditions.size());
            type.conditions.forEach(condition -> IConditionSerializer.toNetwork(condition, friendlyByteBuf, condition.getType().getLocation()));
        }
    }
}

