/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.condition.block;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.data.type.ActionDataType;
import com.daqem.arc.api.condition.AbstractCondition;
import com.daqem.arc.api.condition.ICondition;
import com.daqem.arc.api.condition.serializer.IConditionSerializer;
import com.daqem.arc.api.condition.type.ConditionType;
import com.daqem.arc.api.condition.type.IConditionType;
import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.arc.api.player.ArcServerPlayer;
import com.daqem.arc.player.BlockPosCache;
import com.google.gson.JsonObject;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_9129;

public class NotInBlockPosCacheCondition
extends AbstractCondition {
    public NotInBlockPosCacheCondition(boolean inverted) {
        super(inverted);
    }

    @Override
    public boolean isMet(ActionData actionData) {
        ArcPlayer arcPlayer = actionData.getPlayer();
        if (arcPlayer instanceof ArcServerPlayer) {
            ArcServerPlayer serverPlayer = (ArcServerPlayer)arcPlayer;
            class_2338 blockPos = actionData.getData(ActionDataType.BLOCK_POSITION);
            if (blockPos != null) {
                BlockPosCache blockPosCache = serverPlayer.arc$getBlockPosCache();
                return !blockPosCache.contains((class_2382)blockPos);
            }
        }
        return true;
    }

    @Override
    public IConditionType<? extends ICondition> getType() {
        return ConditionType.NOT_IN_BLOCK_POS_CACHE;
    }

    public static class Serializer
    implements IConditionSerializer<NotInBlockPosCacheCondition> {
        @Override
        public NotInBlockPosCacheCondition fromJson(class_2960 location, JsonObject jsonObject, boolean inverted) {
            return new NotInBlockPosCacheCondition(inverted);
        }

        @Override
        public NotInBlockPosCacheCondition fromNetwork(class_2960 location, class_9129 friendlyByteBuf, boolean inverted) {
            return new NotInBlockPosCacheCondition(inverted);
        }

        @Override
        public void toNetwork(class_9129 friendlyByteBuf, NotInBlockPosCacheCondition type) {
            IConditionSerializer.super.toNetwork(friendlyByteBuf, type);
        }
    }
}

