/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.condition.block.properties;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.data.type.ActionDataType;
import com.daqem.arc.api.condition.AbstractCondition;
import com.daqem.arc.api.condition.serializer.IConditionSerializer;
import com.daqem.arc.api.condition.type.ConditionType;
import com.daqem.arc.api.condition.type.IConditionType;
import com.google.gson.JsonObject;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_9129;

public class BlockHardnessCondition
extends AbstractCondition {
    private final float min;
    private final float max;

    public BlockHardnessCondition(boolean inverted, float min, float max) {
        super(inverted);
        this.min = min;
        this.max = max;
        if (min > max) {
            throw new IllegalArgumentException("min cannot be greater than max for BlockHardnessCondition.");
        }
    }

    @Override
    public class_2561 getDescription() {
        return this.getDescription(Float.valueOf(this.min), Float.valueOf(this.max));
    }

    @Override
    public boolean isMet(ActionData actionData) {
        class_2680 blockState = actionData.getData(ActionDataType.BLOCK_STATE);
        class_2338 blockPos = actionData.getData(ActionDataType.BLOCK_POSITION);
        if (blockState == null || blockPos == null) {
            return false;
        }
        float hardness = blockState.method_26214((class_1922)actionData.getPlayer().arc$getLevel(), blockPos);
        return hardness >= this.min && hardness <= this.max;
    }

    public IConditionType<?> getType() {
        return ConditionType.BLOCK_HARDNESS;
    }

    public static class Serializer
    implements IConditionSerializer<BlockHardnessCondition> {
        @Override
        public BlockHardnessCondition fromJson(class_2960 location, JsonObject jsonObject, boolean inverted) {
            return new BlockHardnessCondition(inverted, class_3518.method_15277((JsonObject)jsonObject, (String)"min", (float)Float.MIN_VALUE), class_3518.method_15277((JsonObject)jsonObject, (String)"max", (float)Float.MAX_VALUE));
        }

        @Override
        public BlockHardnessCondition fromNetwork(class_2960 location, class_9129 friendlyByteBuf, boolean inverted) {
            return new BlockHardnessCondition(inverted, friendlyByteBuf.readFloat(), friendlyByteBuf.readFloat());
        }

        @Override
        public void toNetwork(class_9129 friendlyByteBuf, BlockHardnessCondition type) {
            IConditionSerializer.super.toNetwork(friendlyByteBuf, type);
            friendlyByteBuf.method_52941(type.min);
            friendlyByteBuf.method_52941(type.max);
        }
    }
}

