/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.condition.experience;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.data.type.ActionDataType;
import com.daqem.arc.api.condition.AbstractCondition;
import com.daqem.arc.api.condition.serializer.IConditionSerializer;
import com.daqem.arc.api.condition.type.ConditionType;
import com.daqem.arc.api.condition.type.IConditionType;
import com.google.gson.JsonObject;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_9129;

public class ExpDropCondition
extends AbstractCondition {
    private final int min;
    private final int max;

    public ExpDropCondition(boolean inverted, int min, int max) {
        super(inverted);
        this.min = min;
        this.max = max;
        if (min > max) {
            throw new IllegalArgumentException("min cannot be greater than max for ExpDropCondition.");
        }
    }

    @Override
    public class_2561 getDescription() {
        return this.getDescription(this.min, this.max);
    }

    @Override
    public boolean isMet(ActionData actionData) {
        Integer expDrop = actionData.getData(ActionDataType.EXP_DROP);
        return expDrop != null && expDrop >= this.min && expDrop <= this.max;
    }

    public IConditionType<?> getType() {
        return ConditionType.EXP_DROP;
    }

    public static class Serializer
    implements IConditionSerializer<ExpDropCondition> {
        @Override
        public ExpDropCondition fromJson(class_2960 location, JsonObject jsonObject, boolean inverted) {
            return new ExpDropCondition(inverted, class_3518.method_15260((JsonObject)jsonObject, (String)"min"), class_3518.method_15260((JsonObject)jsonObject, (String)"max"));
        }

        @Override
        public ExpDropCondition fromNetwork(class_2960 location, class_9129 friendlyByteBuf, boolean inverted) {
            return new ExpDropCondition(inverted, friendlyByteBuf.method_10816(), friendlyByteBuf.method_10816());
        }

        @Override
        public void toNetwork(class_9129 friendlyByteBuf, ExpDropCondition type) {
            IConditionSerializer.super.toNetwork(friendlyByteBuf, type);
            friendlyByteBuf.method_10804(type.min);
            friendlyByteBuf.method_10804(type.max);
        }
    }
}

