/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.condition.item;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.data.type.ActionDataType;
import com.daqem.arc.api.condition.AbstractCondition;
import com.daqem.arc.api.condition.serializer.IConditionSerializer;
import com.daqem.arc.api.condition.type.ConditionType;
import com.daqem.arc.api.condition.type.IConditionType;
import com.google.gson.JsonObject;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_9129;

public class ItemCondition
extends AbstractCondition {
    private final class_1799 itemStack;
    private final boolean checkComponents;

    public ItemCondition(boolean inverted, class_1799 itemStack, boolean checkComponents) {
        super(inverted);
        this.itemStack = itemStack;
        this.checkComponents = checkComponents;
    }

    @Override
    public class_2561 getDescription() {
        return this.getDescription(this.itemStack.method_7964());
    }

    @Override
    public boolean isMet(ActionData actionData) {
        class_1792 item = actionData.getData(ActionDataType.ITEM);
        class_1799 itemStack = actionData.getData(ActionDataType.ITEM_STACK);
        boolean hasItem = item != null || itemStack != null;
        boolean passOnItem = item != null && item == this.itemStack.method_7909();
        boolean passOnItemStack = itemStack != null && this.testItemStack(itemStack);
        return hasItem && (passOnItem || passOnItemStack);
    }

    private boolean testItemStack(class_1799 itemStack) {
        boolean sameItem = class_1799.method_7984((class_1799)this.itemStack, (class_1799)itemStack);
        boolean hasCount = this.itemStack.method_7947() > 1;
        boolean sameCount = itemStack.method_7947() == this.itemStack.method_7947();
        boolean passOnCount = !hasCount || sameCount;
        boolean hasComponents = !this.checkComponents || !this.itemStack.method_57353().method_57837();
        boolean sameComponents = !this.checkComponents || class_1799.method_31577((class_1799)this.itemStack, (class_1799)itemStack);
        boolean passOnComponents = !this.checkComponents || !hasComponents || sameComponents;
        return sameItem && passOnCount && passOnComponents;
    }

    public IConditionType<?> getType() {
        return ConditionType.ITEM;
    }

    public static class Serializer
    implements IConditionSerializer<ItemCondition> {
        @Override
        public ItemCondition fromJson(class_2960 location, JsonObject jsonObject, boolean inverted) {
            return new ItemCondition(inverted, this.getItemStack(jsonObject.get("item")), class_3518.method_15258((JsonObject)jsonObject, (String)"check_components", (boolean)true));
        }

        @Override
        public ItemCondition fromNetwork(class_2960 location, class_9129 friendlyByteBuf, boolean inverted) {
            return new ItemCondition(inverted, (class_1799)class_1799.field_48349.decode((Object)friendlyByteBuf), friendlyByteBuf.readBoolean());
        }

        @Override
        public void toNetwork(class_9129 friendlyByteBuf, ItemCondition type) {
            IConditionSerializer.super.toNetwork(friendlyByteBuf, type);
            class_1799.field_48349.encode((Object)friendlyByteBuf, (Object)type.itemStack);
            friendlyByteBuf.method_52964(type.checkComponents);
        }
    }
}

