/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.condition.item;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.condition.AbstractCondition;
import com.daqem.arc.api.condition.serializer.IConditionSerializer;
import com.daqem.arc.api.condition.type.ConditionType;
import com.daqem.arc.api.condition.type.IConditionType;
import com.google.gson.JsonObject;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_9129;

public class ItemInHandCondition
extends AbstractCondition {
    private final class_1799 itemStack;
    private final class_1268 hand;

    public ItemInHandCondition(boolean inverted, class_1799 itemStack, class_1268 hand) {
        super(inverted);
        this.itemStack = itemStack;
        this.hand = hand;
    }

    @Override
    public class_2561 getDescription() {
        return this.getDescription(this.itemStack.method_7964(), this.hand.name().toLowerCase().replace("_", " "));
    }

    @Override
    public boolean isMet(ActionData actionData) {
        class_1657 player = actionData.getPlayer().arc$getPlayer();
        class_1792 targetItem = this.itemStack.method_7909();
        if (this.hand == null) {
            return player.method_6047().method_7909() == targetItem || player.method_6079().method_7909() == targetItem;
        }
        return player.method_5998(this.hand).method_7909() == targetItem;
    }

    public IConditionType<?> getType() {
        return ConditionType.ITEM_IN_HAND;
    }

    public static class Serializer
    implements IConditionSerializer<ItemInHandCondition> {
        @Override
        public ItemInHandCondition fromJson(class_2960 location, JsonObject jsonObject, boolean inverted) {
            return new ItemInHandCondition(inverted, this.getItemStack(jsonObject.get("item")), this.getOptionalHand(jsonObject, "hand"));
        }

        @Override
        public ItemInHandCondition fromNetwork(class_2960 location, class_9129 friendlyByteBuf, boolean inverted) {
            class_1799 itemStack = (class_1799)class_1799.field_48349.decode((Object)friendlyByteBuf);
            class_1268 hand = friendlyByteBuf.readBoolean() ? (class_1268)friendlyByteBuf.method_10818(class_1268.class) : null;
            return new ItemInHandCondition(inverted, itemStack, hand);
        }

        @Override
        public void toNetwork(class_9129 friendlyByteBuf, ItemInHandCondition type) {
            IConditionSerializer.super.toNetwork(friendlyByteBuf, type);
            class_1799.field_48349.encode((Object)friendlyByteBuf, (Object)type.itemStack);
            friendlyByteBuf.method_52964(type.hand != null);
            if (type.hand != null) {
                friendlyByteBuf.method_10817((Enum)type.hand);
            }
        }
    }
}

