/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.condition.scoreboard;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.condition.AbstractCondition;
import com.daqem.arc.api.condition.serializer.IConditionSerializer;
import com.daqem.arc.api.condition.type.ConditionType;
import com.daqem.arc.api.condition.type.IConditionType;
import com.google.gson.JsonObject;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_9015;
import net.minecraft.class_9129;

public class ScoreboardCondition
extends AbstractCondition {
    private final String objective;
    private final int min;
    private final int max;

    public ScoreboardCondition(boolean inverted, String objective, int min, int max) {
        super(inverted);
        this.objective = objective;
        this.min = min;
        this.max = max;
        if (min > max) {
            throw new IllegalArgumentException("min cannot be greater than max for ScoreboardCondition.");
        }
    }

    @Override
    public class_2561 getDescription() {
        return this.getDescription(this.objective, this.min, this.max);
    }

    @Override
    public boolean isMet(ActionData actionData) {
        class_269 scoreboard = actionData.getPlayer().arc$getPlayer().method_7327();
        class_266 objective = scoreboard.method_1170(this.objective);
        if (objective != null) {
            int score = scoreboard.method_1180((class_9015)actionData.getPlayer(), objective).method_55409();
            return score >= this.min && score <= this.max;
        }
        return false;
    }

    public IConditionType<?> getType() {
        return ConditionType.SCOREBOARD;
    }

    public static class Serializer
    implements IConditionSerializer<ScoreboardCondition> {
        @Override
        public ScoreboardCondition fromJson(class_2960 location, JsonObject jsonObject, boolean inverted) {
            return new ScoreboardCondition(inverted, this.getString(jsonObject, "objective"), class_3518.method_15260((JsonObject)jsonObject, (String)"min"), class_3518.method_15260((JsonObject)jsonObject, (String)"max"));
        }

        @Override
        public ScoreboardCondition fromNetwork(class_2960 location, class_9129 friendlyByteBuf, boolean inverted) {
            return new ScoreboardCondition(inverted, friendlyByteBuf.method_19772(), friendlyByteBuf.readInt(), friendlyByteBuf.readInt());
        }

        @Override
        public void toNetwork(class_9129 friendlyByteBuf, ScoreboardCondition type) {
            IConditionSerializer.super.toNetwork(friendlyByteBuf, type);
            friendlyByteBuf.method_10814(type.objective);
            friendlyByteBuf.method_53002(type.min);
            friendlyByteBuf.method_53002(type.max);
        }
    }
}

