/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.reward.entity;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.data.type.ActionDataType;
import com.daqem.arc.api.action.result.ActionResult;
import com.daqem.arc.api.reward.AbstractReward;
import com.daqem.arc.api.reward.serializer.IRewardSerializer;
import com.daqem.arc.api.reward.type.IRewardType;
import com.daqem.arc.api.reward.type.RewardType;
import com.google.gson.JsonObject;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_3518;
import net.minecraft.class_9129;

public class EntityOnFireReward
extends AbstractReward {
    private final int fireTicks;

    public EntityOnFireReward(double chance, int priority, int fireTicks) {
        super(chance, priority);
        this.fireTicks = fireTicks;
    }

    @Override
    public class_2561 getDescription() {
        return this.getDescription(String.format("%.1f", Float.valueOf((float)this.fireTicks / 20.0f)));
    }

    @Override
    public IRewardType<?> getType() {
        return RewardType.ENTITY_ON_FIRE;
    }

    @Override
    public ActionResult apply(ActionData actionData) {
        class_1297 entity = actionData.getData(ActionDataType.ENTITY);
        if (entity != null) {
            entity.method_20803(this.fireTicks);
        }
        return new ActionResult();
    }

    public static class Serializer
    implements IRewardSerializer<EntityOnFireReward> {
        @Override
        public EntityOnFireReward fromJson(JsonObject jsonObject, double chance, int priority) {
            return new EntityOnFireReward(chance, priority, class_3518.method_15260((JsonObject)jsonObject, (String)"ticks"));
        }

        @Override
        public EntityOnFireReward fromNetwork(class_9129 friendlyByteBuf, double chance, int priority) {
            return new EntityOnFireReward(chance, priority, friendlyByteBuf.readInt());
        }

        @Override
        public void toNetwork(class_9129 friendlyByteBuf, EntityOnFireReward type) {
            IRewardSerializer.super.toNetwork(friendlyByteBuf, type);
            friendlyByteBuf.method_53002(type.fireTicks);
        }
    }
}

