/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.reward.entity;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.data.type.ActionDataType;
import com.daqem.arc.api.action.result.ActionResult;
import com.daqem.arc.api.reward.AbstractReward;
import com.daqem.arc.api.reward.serializer.IRewardSerializer;
import com.daqem.arc.api.reward.type.IRewardType;
import com.daqem.arc.api.reward.type.RewardType;
import com.google.gson.JsonObject;
import java.util.Random;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1753;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3518;
import net.minecraft.class_3965;
import net.minecraft.class_9129;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class MultipleArrowsReward
extends AbstractReward {
    private final int amount;

    public MultipleArrowsReward(double chance, int priority, int amount) {
        super(chance, priority);
        this.amount = amount;
    }

    @Override
    public class_2561 getDescription() {
        return this.getDescription(this.amount);
    }

    @Override
    public IRewardType<?> getType() {
        return RewardType.MULTIPLE_ARROWS;
    }

    @Override
    public ActionResult apply(ActionData actionData) {
        class_1297 entity = actionData.getData(ActionDataType.ENTITY);
        if (entity instanceof class_1665) {
            class_1799 bow;
            class_1665 shotArrow = (class_1665)entity;
            class_1657 player = actionData.getPlayer().arc$getPlayer();
            if (player.method_6047().method_7909() instanceof class_1753) {
                bow = player.method_6047();
            } else if (player.method_6079().method_7909() instanceof class_1753) {
                bow = player.method_6079();
            } else {
                return new ActionResult();
            }
            class_1792 class_17922 = bow.method_7909();
            if (class_17922 instanceof class_1753) {
                class_1753 bowItem = (class_1753)class_17922;
                float power = class_1753.method_7722((int)(bowItem.method_7881(bow, (class_1309)player) - player.method_6014()));
                float[] afloat = this.getShotPitches(new Random());
                int[] arrowPositions = MultipleArrowsReward.scatterArrows(this.amount);
                for (int i = 0; i < this.amount; ++i) {
                    this.shootProjectile(shotArrow, player.method_37908(), (class_1309)player, bow, class_1802.field_8107.method_7854(), afloat[1], power * 3.0f, arrowPositions[i]);
                }
            }
        }
        return new ActionResult();
    }

    public static int[] scatterArrows(int numArrows) {
        if (numArrows < 1 || numArrows > 20) {
            throw new IllegalArgumentException("Number of arrows should be between 1 and 20.");
        }
        int[] arrowPositions = new int[numArrows];
        double interval = 20.0 / (double)(numArrows - 1);
        for (int i = 0; i < numArrows; ++i) {
            arrowPositions[i] = (int)(-10.0 + (double)i * interval);
        }
        return arrowPositions;
    }

    private void shootProjectile(class_1665 shotArrow, class_1937 level, class_1309 livingEntity, class_1799 bow, final class_1799 arrow, float shotPitch, float power, float pitch) {
        if (livingEntity instanceof class_1657) {
            class_1657 player = (class_1657)livingEntity;
            class_1665 projectile = new class_1665(this, class_1299.field_6122, livingEntity, level, arrow, bow){

                @NotNull
                protected class_1799 method_57314() {
                    return arrow;
                }

                protected void method_24920(@NotNull class_3965 blockHitResult) {
                    super.method_24920(blockHitResult);
                    this.method_31472();
                }
            };
            projectile.field_7572 = class_1665.class_1666.field_7594;
            class_243 vec3 = player.method_18864(1.0f);
            Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(pitch * ((float)Math.PI / 180)), vec3.field_1352, vec3.field_1351, vec3.field_1350);
            class_243 vec32 = player.method_5828(1.0f);
            Vector3f vector3f = vec32.method_46409().rotate((Quaternionfc)quaternionf);
            projectile.method_7485((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), power, 1.0f);
            bow.method_7970(1, (class_1309)player, class_1309.method_56079((class_1268)player.method_6058()));
            level.method_8649((class_1297)projectile);
            level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14600, class_3419.field_15248, 1.0f, shotPitch);
        }
    }

    private float[] getShotPitches(Random random) {
        boolean flag = random.nextBoolean();
        return new float[]{1.0f, this.getRandomShotPitch(flag, random), this.getRandomShotPitch(!flag, random)};
    }

    private float getRandomShotPitch(boolean p_150798_, Random random) {
        float f = p_150798_ ? 0.63f : 0.43f;
        return 1.0f / (random.nextFloat() * 0.5f + 1.8f) + f;
    }

    public static class Serializer
    implements IRewardSerializer<MultipleArrowsReward> {
        @Override
        public MultipleArrowsReward fromJson(JsonObject jsonObject, double chance, int priority) {
            return new MultipleArrowsReward(chance, priority, Math.min(20, Math.max(1, class_3518.method_15260((JsonObject)jsonObject, (String)"amount"))));
        }

        @Override
        public MultipleArrowsReward fromNetwork(class_9129 friendlyByteBuf, double chance, int priority) {
            return new MultipleArrowsReward(chance, priority, friendlyByteBuf.readInt());
        }

        @Override
        public void toNetwork(class_9129 friendlyByteBuf, MultipleArrowsReward type) {
            IRewardSerializer.super.toNetwork(friendlyByteBuf, type);
            friendlyByteBuf.method_53002(type.amount);
        }
    }
}

