/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.serializer;

import com.daqem.arc.api.action.holder.type.IActionHolderType;
import com.daqem.arc.data.serializer.ElementConverter;
import com.daqem.arc.registry.ArcRegistry;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.class_1268;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_4081;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public interface ArcSerializer {
    default public class_2960 getResourceLocation(JsonObject jsonObject, String elementName) {
        return class_2960.method_60654((String)this.getString(jsonObject, elementName));
    }

    default public class_1799 getItemStack(JsonElement element) {
        return (class_1799)((Pair)class_1799.field_24671.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).result().orElseThrow(() -> new JsonParseException("Invalid item stack"))).getFirst();
    }

    default public IActionHolderType<?> getHolderType(JsonObject jsonObject, String elementName) {
        return new ElementConverter(ArcRegistry.ACTION_HOLDER).convertToElement(this.getString(jsonObject, elementName));
    }

    default public class_1792 getItem(JsonObject jsonObject, String elementName) {
        return (class_1792)new ElementConverter(class_7923.field_41178).convertToElement(this.getString(jsonObject, elementName));
    }

    default public class_2248 getBlock(JsonObject jsonObject, String elementName) {
        return (class_2248)new ElementConverter(class_7923.field_41175).convertToElement(this.getString(jsonObject, elementName));
    }

    default public class_1291 getMobEffect(JsonObject jsonObject, String elementName) {
        return (class_1291)new ElementConverter(class_7923.field_41174).convertToElement(this.getString(jsonObject, elementName));
    }

    default public class_1299<?> getEntityType(JsonObject jsonObject, String elementName) {
        return (class_1299)new ElementConverter(class_7923.field_41177).convertToElement(this.getString(jsonObject, elementName));
    }

    default public String getString(JsonObject jsonObject, String elementName) {
        return class_3518.method_15265((JsonObject)jsonObject, (String)elementName);
    }

    default public List<String> getStrings(JsonObject jsonObject, String elementName) {
        return StreamSupport.stream(class_3518.method_15261((JsonObject)jsonObject, (String)elementName).spliterator(), false).map(JsonElement::getAsString).collect(Collectors.toList());
    }

    default public <E> List<E> getElementsFromJson(class_2378<E> registry, JsonObject jsonObject, String elementName) {
        return new ElementConverter<E>(registry).convertToElements(this.getStrings(jsonObject, elementName));
    }

    default public <E> List<class_6862<E>> getTagKeysFromJson(class_2378<E> registry, JsonObject jsonObject, String elementName) {
        return new ElementConverter<E>(registry).convertToElementTags(this.getStrings(jsonObject, elementName));
    }

    default public List<class_2248> getBlocks(JsonObject jsonObject, String elementName) {
        return this.getElementsFromJson((class_2378)class_7923.field_41175, jsonObject, elementName);
    }

    default public List<class_6862<class_2248>> getBlockTags(JsonObject jsonObject, String elementName) {
        return this.getTagKeysFromJson((class_2378)class_7923.field_41175, jsonObject, elementName);
    }

    default public List<class_1792> getItems(JsonObject jsonObject, String elementName) {
        return this.getElementsFromJson((class_2378)class_7923.field_41178, jsonObject, elementName);
    }

    default public List<class_6862<class_1792>> getItemTags(JsonObject jsonObject, String elementName) {
        return this.getTagKeysFromJson((class_2378)class_7923.field_41178, jsonObject, elementName);
    }

    default public List<class_1299<?>> getEntityTypes(JsonObject jsonObject, String elementName) {
        return this.getElementsFromJson((class_2378)class_7923.field_41177, jsonObject, elementName);
    }

    default public class_1268 getHand(JsonObject jsonObject, String elementName) {
        class_1268 hand;
        String handName = this.getString(jsonObject, elementName);
        try {
            hand = class_1268.valueOf((String)handName);
        }
        catch (IllegalArgumentException e) {
            throw new JsonParseException("Invalid hand, expected to find a valid hand ('MAIN_HAND' or 'OFF_HAND').");
        }
        return hand;
    }

    @Nullable
    default public class_1268 getOptionalHand(JsonObject jsonObject, String elementName) {
        if (jsonObject.has(elementName)) {
            return this.getHand(jsonObject, elementName);
        }
        return null;
    }

    default public class_4081 getMobEffectCategory(JsonObject jsonObject, String elementName) {
        class_4081 effectCategory;
        String effectCategoryName = this.getString(jsonObject, elementName);
        try {
            effectCategory = class_4081.valueOf((String)effectCategoryName);
        }
        catch (IllegalArgumentException e) {
            throw new JsonParseException("Invalid effect_category, expected to find a valid effect category ('BENEFICIAL', 'HARMFUL' or 'NEUTRAL').");
        }
        return effectCategory;
    }

    default public class_5321<class_1937> getDimension(JsonObject jsonObject, String elementName) {
        class_5321 dimension;
        String dimensionName = this.getString(jsonObject, elementName);
        try {
            dimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)dimensionName));
        }
        catch (IllegalArgumentException e) {
            throw new JsonParseException("Invalid dimension, expected to find a valid dimension.");
        }
        return dimension;
    }
}

