/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data;

import com.daqem.arc.Arc;
import com.daqem.arc.api.action.IAction;
import com.daqem.arc.api.action.holder.ActionHolderManager;
import com.daqem.arc.api.action.type.IActionType;
import com.daqem.arc.registry.ArcRegistry;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import org.jetbrains.annotations.NotNull;

public class ActionManager
extends class_4080<List<IAction>> {
    @NotNull
    protected List<IAction> prepare(class_3300 resourceManager, class_3695 profilerFiller) {
        Map<class_2960, class_3298> resourceMap = resourceManager.method_14488("arc", resourceLocation -> resourceLocation.method_12832().endsWith(".json")).entrySet().stream().collect(Collectors.toMap(entry -> class_2960.method_60655((String)((class_2960)entry.getKey()).method_12836(), (String)((class_2960)entry.getKey()).method_12832().substring(0, ((class_2960)entry.getKey()).method_12832().length() - ".json".length()).substring("arc/".length())), Map.Entry::getValue));
        HashMap<class_2960, JsonObject> map = new HashMap<class_2960, JsonObject>();
        for (Map.Entry<class_2960, class_3298> entry2 : resourceMap.entrySet()) {
            class_2960 location = entry2.getKey();
            try {
                JsonObject jsonElement = class_3518.method_15255((Reader)entry2.getValue().method_43039());
                map.put(location, jsonElement);
            }
            catch (Exception runtimeException) {
                Arc.LOGGER.error("Parsing error loading action {}", (Object)location, (Object)runtimeException);
            }
        }
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (!Arc.isDebugEnvironment()) {
            map.entrySet().removeIf(entry -> ((class_2960)entry.getKey()).method_12836().equals("debug"));
        }
        for (Map.Entry entry3 : map.entrySet()) {
            class_2960 location = (class_2960)entry3.getKey();
            try {
                IAction action = ActionManager.fromJson(location, class_3518.method_15295((JsonElement)((JsonElement)entry3.getValue()), (String)"top element"));
                actions.add(action);
            }
            catch (JsonParseException | IllegalArgumentException runtimeException) {
                Arc.LOGGER.error("Parsing error loading action {}", (Object)location, (Object)runtimeException);
            }
        }
        return actions;
    }

    protected void apply(List<IAction> actions, class_3300 resourceManager, class_3695 profilerFiller) {
        ActionHolderManager actionHolderManager = ActionHolderManager.getInstance();
        actionHolderManager.clearAllActions();
        actionHolderManager.registerActions(actions);
        Arc.LOGGER.info("Loaded {} actions", (Object)actions.size());
    }

    public static IAction fromJson(class_2960 location, JsonObject jsonObject) {
        String type = class_3518.method_15265((JsonObject)jsonObject, (String)"type");
        return ((IActionType)ArcRegistry.ACTION.method_17966(class_2960.method_60654((String)type)).orElseThrow(() -> new JsonSyntaxException("Invalid or unsupported action type '" + type + "'"))).getSerializer().fromJson(location, jsonObject);
    }
}

