/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.condition.block;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.data.type.ActionDataType;
import com.daqem.arc.api.condition.AbstractCondition;
import com.daqem.arc.api.condition.serializer.IConditionSerializer;
import com.daqem.arc.api.condition.type.ConditionType;
import com.daqem.arc.api.condition.type.IConditionType;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;

public class BlocksCondition
extends AbstractCondition {
    private final List<class_2248> blocks;
    private final List<class_6862<class_2248>> blockTags;

    public BlocksCondition(boolean inverted, List<class_2248> blocks, List<class_6862<class_2248>> blockTags) {
        super(inverted);
        this.blocks = blocks;
        this.blockTags = blockTags;
    }

    @Override
    public class_2561 getDescription() {
        return this.getDescription(this.blocks.stream().map(class_2248::method_9518).toArray(class_2561[]::new), this.blockTags.stream().map(class_6862::comp_327).toArray(class_2960[]::new));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isMet(ActionData actionData) {
        class_2680 blockState = actionData.getData(ActionDataType.BLOCK_STATE);
        if (blockState == null) return false;
        if (this.blocks.contains(blockState.method_26204())) return true;
        if (!this.blockTags.stream().anyMatch(arg_0 -> ((class_2680)blockState).method_26164(arg_0))) return false;
        return true;
    }

    public IConditionType<?> getType() {
        return ConditionType.BLOCKS;
    }

    public List<class_2248> getBlocks() {
        return this.blocks;
    }

    public List<class_6862<class_2248>> getBlockTags() {
        return this.blockTags;
    }

    public List<class_2248> getAllBlocks(class_5455 registryAccess) {
        ArrayList<class_2248> allBlocks = new ArrayList<class_2248>(this.blocks);
        for (class_6862<class_2248> tag : this.blockTags) {
            registryAccess.method_30530(class_7924.field_41254).method_46733(tag).ifPresent(x -> allBlocks.addAll(x.method_40239().map(class_6880::comp_349).toList()));
        }
        return allBlocks;
    }

    public static class Serializer
    implements IConditionSerializer<BlocksCondition> {
        @Override
        public BlocksCondition fromJson(class_2960 location, JsonObject jsonObject, boolean inverted) {
            return new BlocksCondition(inverted, this.getBlocks(jsonObject, "blocks"), this.getBlockTags(jsonObject, "blocks"));
        }

        @Override
        public BlocksCondition fromNetwork(class_2960 location, class_9129 friendlyByteBuf, boolean inverted) {
            int i;
            int blockCount = friendlyByteBuf.method_10816();
            int tagCount = friendlyByteBuf.method_10816();
            ArrayList<class_2248> blocks = new ArrayList<class_2248>();
            ArrayList<class_6862<class_2248>> blockTags = new ArrayList<class_6862<class_2248>>();
            for (i = 0; i < blockCount; ++i) {
                blocks.add((class_2248)class_7923.field_41175.method_10200(friendlyByteBuf.method_10816()));
            }
            for (i = 0; i < tagCount; ++i) {
                blockTags.add((class_6862<class_2248>)class_6862.method_40092((class_5321)class_7923.field_41175.method_46765(), (class_2960)friendlyByteBuf.method_10810()));
            }
            return new BlocksCondition(inverted, blocks, blockTags);
        }

        @Override
        public void toNetwork(class_9129 friendlyByteBuf, BlocksCondition type) {
            IConditionSerializer.super.toNetwork(friendlyByteBuf, type);
            friendlyByteBuf.method_10804(type.blocks.size());
            friendlyByteBuf.method_10804(type.blockTags.size());
            type.blocks.forEach(block -> friendlyByteBuf.method_10804(class_7923.field_41175.method_10206(block)));
            type.blockTags.forEach(tag -> friendlyByteBuf.method_10812(tag.comp_327()));
        }
    }
}

