/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.condition.entity;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.data.type.ActionDataType;
import com.daqem.arc.api.condition.AbstractCondition;
import com.daqem.arc.api.condition.serializer.IConditionSerializer;
import com.daqem.arc.api.condition.type.ConditionType;
import com.daqem.arc.api.condition.type.IConditionType;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9129;

public class EntityTypesCondition
extends AbstractCondition {
    private final List<class_1299<?>> entityTypes;

    public EntityTypesCondition(boolean inverted, List<class_1299<?>> entityTypes) {
        super(inverted);
        this.entityTypes = entityTypes;
    }

    @Override
    public class_2561 getDescription() {
        return this.getDescription(this.entityTypes.stream().map(class_1299::method_5897).toArray(class_2561[]::new));
    }

    @Override
    public boolean isMet(ActionData actionData) {
        class_1297 entity = actionData.getData(ActionDataType.ENTITY);
        return entity != null && this.entityTypes.contains(entity.method_5864());
    }

    public IConditionType<?> getType() {
        return ConditionType.ENTITY_TYPES;
    }

    public List<class_1299<?>> getEntityTypes() {
        return this.entityTypes;
    }

    public static class Serializer
    implements IConditionSerializer<EntityTypesCondition> {
        @Override
        public EntityTypesCondition fromJson(class_2960 location, JsonObject jsonObject, boolean inverted) {
            return new EntityTypesCondition(inverted, this.getEntityTypes(jsonObject, "entity_types"));
        }

        @Override
        public EntityTypesCondition fromNetwork(class_2960 location, class_9129 friendlyByteBuf, boolean inverted) {
            int entityTypesSize = friendlyByteBuf.method_10816();
            ArrayList entityTypes = new ArrayList();
            for (int i = 0; i < entityTypesSize; ++i) {
                entityTypes.add((class_1299)class_7923.field_41177.method_10200(friendlyByteBuf.method_10816()));
            }
            return new EntityTypesCondition(inverted, entityTypes);
        }

        @Override
        public void toNetwork(class_9129 friendlyByteBuf, EntityTypesCondition type) {
            IConditionSerializer.super.toNetwork(friendlyByteBuf, type);
            friendlyByteBuf.method_10804(type.entityTypes.size());
            for (class_1299<?> entityType : type.entityTypes) {
                friendlyByteBuf.method_10804(class_7923.field_41177.method_10206(entityType));
            }
        }
    }
}

