/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.condition.movement;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.data.type.ActionDataType;
import com.daqem.arc.api.condition.AbstractCondition;
import com.daqem.arc.api.condition.serializer.IConditionSerializer;
import com.daqem.arc.api.condition.type.ConditionType;
import com.daqem.arc.api.condition.type.IConditionType;
import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.arc.api.player.ArcServerPlayer;
import com.google.gson.JsonObject;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_9129;

public class DistanceCondition
extends AbstractCondition {
    private final int distanceInBlocks;

    public DistanceCondition(boolean inverted, int distanceInBlocks) {
        super(inverted);
        this.distanceInBlocks = distanceInBlocks;
    }

    @Override
    public class_2561 getDescription() {
        return this.getDescription(this.distanceInBlocks);
    }

    @Override
    public boolean isMet(ActionData actionData) {
        ArcPlayer arcPlayer = actionData.getPlayer();
        if (arcPlayer instanceof ArcServerPlayer) {
            ArcServerPlayer serverPlayer = (ArcServerPlayer)arcPlayer;
            Integer totalDistanceMovedInCm = actionData.getData(ActionDataType.DISTANCE_IN_CM);
            if (totalDistanceMovedInCm != null) {
                totalDistanceMovedInCm = totalDistanceMovedInCm + serverPlayer.arc$getLastRemainderInCm(this);
                double lastTotalDistanceMovedInCm = serverPlayer.arc$getLastDistanceInCm(this);
                double currentDistanceMovedInCm = (double)totalDistanceMovedInCm.intValue() - lastTotalDistanceMovedInCm;
                double currentDistanceMovedInBlocks = currentDistanceMovedInCm / 100.0;
                if (currentDistanceMovedInBlocks >= (double)this.distanceInBlocks) {
                    serverPlayer.arc$setLastDistanceInCm(this, totalDistanceMovedInCm);
                    return true;
                }
                serverPlayer.arc$setLastRemainderInCm(this, (int)(currentDistanceMovedInBlocks % (double)this.distanceInBlocks) * 100);
            }
        }
        return false;
    }

    public IConditionType<?> getType() {
        return ConditionType.DISTANCE;
    }

    public int getDistanceInBlocks() {
        return this.distanceInBlocks;
    }

    public static class Serializer
    implements IConditionSerializer<DistanceCondition> {
        @Override
        public DistanceCondition fromJson(class_2960 location, JsonObject jsonObject, boolean inverted) {
            return new DistanceCondition(inverted, class_3518.method_15260((JsonObject)jsonObject, (String)"distance_in_blocks"));
        }

        @Override
        public DistanceCondition fromNetwork(class_2960 location, class_9129 friendlyByteBuf, boolean inverted) {
            return new DistanceCondition(inverted, friendlyByteBuf.method_10816());
        }

        @Override
        public void toNetwork(class_9129 friendlyByteBuf, DistanceCondition type) {
            IConditionSerializer.super.toNetwork(friendlyByteBuf, type);
            friendlyByteBuf.method_10804(type.distanceInBlocks);
        }
    }
}

