/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.reward.experience;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.data.type.ActionDataType;
import com.daqem.arc.api.action.result.ActionResult;
import com.daqem.arc.api.reward.AbstractReward;
import com.daqem.arc.api.reward.serializer.IRewardSerializer;
import com.daqem.arc.api.reward.type.IRewardType;
import com.daqem.arc.api.reward.type.RewardType;
import com.google.gson.JsonObject;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3518;
import net.minecraft.class_9129;

public class ExpMultiplierReward
extends AbstractReward {
    private final int multiplier;

    public ExpMultiplierReward(double chance, int priority, int multiplier) {
        super(chance, priority);
        this.multiplier = multiplier;
    }

    @Override
    public class_2561 getDescription() {
        return this.getDescription(this.multiplier);
    }

    @Override
    public ActionResult apply(ActionData actionData) {
        class_2338 blockPos;
        Integer exp;
        class_1937 level = actionData.getData(ActionDataType.WORLD);
        if (level == null) {
            level = actionData.getPlayer().arc$getLevel();
        }
        if (level != null && (exp = actionData.getData(ActionDataType.EXP_DROP)) != null && exp * this.multiplier - exp > 0 && (blockPos = actionData.getData(ActionDataType.BLOCK_POSITION)) != null) {
            level.method_8649((class_1297)new class_1303(level, (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), exp * this.multiplier - exp));
        }
        return new ActionResult();
    }

    @Override
    public IRewardType<?> getType() {
        return RewardType.EXP_MULTIPLIER;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public static class Serializer
    implements IRewardSerializer<ExpMultiplierReward> {
        @Override
        public ExpMultiplierReward fromJson(JsonObject jsonObject, double chance, int priority) {
            return new ExpMultiplierReward(chance, priority, class_3518.method_15260((JsonObject)jsonObject, (String)"multiplier"));
        }

        @Override
        public ExpMultiplierReward fromNetwork(class_9129 friendlyByteBuf, double chance, int priority) {
            return new ExpMultiplierReward(chance, priority, friendlyByteBuf.readInt());
        }

        @Override
        public void toNetwork(class_9129 friendlyByteBuf, ExpMultiplierReward type) {
            IRewardSerializer.super.toNetwork(friendlyByteBuf, type);
            friendlyByteBuf.method_53002(type.multiplier);
        }
    }
}

