/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.arc.data.reward.experience;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.result.ActionResult;
import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.arc.api.reward.AbstractReward;
import com.daqem.arc.api.reward.serializer.IRewardSerializer;
import com.daqem.arc.api.reward.type.IRewardType;
import com.daqem.arc.api.reward.type.RewardType;
import com.google.gson.JsonObject;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3518;
import net.minecraft.class_9129;

public class ExpReward
extends AbstractReward {
    private final int min;
    private final int max;

    public ExpReward(double chance, int priority, int min, int max) {
        super(chance, priority);
        this.min = min;
        this.max = max;
        if (min > max) {
            throw new IllegalArgumentException("min cannot be greater than max for ExpActionReward.");
        }
    }

    @Override
    public class_2561 getDescription() {
        return this.getDescription(this.min, this.max);
    }

    @Override
    public IRewardType<?> getType() {
        return RewardType.EXP;
    }

    @Override
    public ActionResult apply(ActionData actionData) {
        ArcPlayer player = actionData.getPlayer();
        int exp = ((class_3222)player).method_59922().method_43051(this.min, this.max + 1);
        ((class_3222)player).method_7255(exp);
        return new ActionResult();
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public static class Serializer
    implements IRewardSerializer<ExpReward> {
        @Override
        public ExpReward fromJson(JsonObject jsonObject, double chance, int priority) {
            return new ExpReward(chance, priority, class_3518.method_15260((JsonObject)jsonObject, (String)"min"), class_3518.method_15260((JsonObject)jsonObject, (String)"max"));
        }

        @Override
        public ExpReward fromNetwork(class_9129 friendlyByteBuf, double chance, int priority) {
            return new ExpReward(chance, priority, friendlyByteBuf.readInt(), friendlyByteBuf.readInt());
        }

        @Override
        public void toNetwork(class_9129 friendlyByteBuf, ExpReward type) {
            IRewardSerializer.super.toNetwork(friendlyByteBuf, type);
            friendlyByteBuf.method_53002(type.min);
            friendlyByteBuf.method_53002(type.max);
        }
    }
}

